;+
; Project     :	CLUSTER - POLAR - PULSAUR
;
; Name        :	RCS_TEXT
;
; Purpose     :	Writes output to text widget.
;
; Explanation : Sends output to text widget keeping track of line number so that can reposition
;               display to current position.
;               Action depends on silent flag :
;                  0 : outputs
;                  1 : silent
;
; Use         : < rcs_text, text, RESET=reset >
;
; Inputs      : text   : STRARR[] text for display.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : RESET : resets text widget.
;               OVERRIDE : FLAG so that produces output even if
;                          silent running.
;
; Written     :	Version 0.0, Martin Carter, RAL, 1/May/00
;
; Modified    : Version 0.1, 10/2/01
;                 Moved silent common block to rcs_text.
;                 Changed to using different levels of silence.
;               Version 0.2, 13/03/01
;                 Changed use of silent flag.
;               Version 0.3, 14/03/01
;                 Added OVERRIDE keyword..
;                 Removed ids from argument list.
;               Version 0.4, 13/06/01
;                 Allowed ids to be undefined.
;
; Version     :	Version 0.4, 13/06/01
;-
;**********************************************************

PRO rcs_text, text, RESET=reset, OVERRIDE=override

  ; do lines individually so properly separated

  ; check if reset

  IF KEYWORD_SET(reset) THEN BEGIN

    ids = rcs_get_ids()

    IF NOT WIDGET_INFO(ids.text,/VALID_ID) THEN RETURN

    FOR k = 0, N_ELEMENTS(text)-1 DO WIDGET_CONTROL, ids.text, SET_VALUE=text[k], APPEND=(k NE 0)

    WIDGET_CONTROL, ids.text, SET_UVALUE=N_ELEMENTS(text)

    WIDGET_CONTROL, ids.text, SET_TEXT_TOP_LINE=(N_ELEMENTS(text)-10) > 0

    RETURN

  ENDIF

  IF NOT KEYWORD_SET(override) AND rcs_get_silent() THEN RETURN

  ids = rcs_get_ids()

  IF KEYWORD_SET(ids) THEN IF WIDGET_INFO(ids.text,/VALID_ID) THEN BEGIN

    WIDGET_CONTROL, ids.text, GET_UVALUE=nlines

    FOR k = 0, N_ELEMENTS(text)-1 DO WIDGET_CONTROL, ids.text, SET_VALUE=text[k], /APPEND

    WIDGET_CONTROL, ids.text, SET_UVALUE=nlines+N_ELEMENTS(text)

    WIDGET_CONTROL, ids.text, SET_TEXT_TOP_LINE=(nlines+N_ELEMENTS(text)-10) > 0

    RETURN

  ENDIF

  FOR k = 0, N_ELEMENTS(text)-1 DO PRINT, text[k]

END

