;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_TIMER
;
; Purpose     :	Manages TIMER events from RCS process.
;
; Explanation : Deals with events from the RCS_IN widget and uses TIMER events to trigger data extraction
;               from input data file.
;
; Use         : < rcs_event, event >
;
; Inputs      : event : EVENT structure from TIMER.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 19/1/01
;
; Modified    :	Version 0.1, 10/2/01
;                 Changed to common blocks.
;               Version 0.2, 22/04/01
;                 Processed HK data befo0re SC data.
;
; Version     :	Version 0.2, 22/04/01
;-
;**********************************************************

PRO rcs_timer, event

  ; get widget IDs

  ids = rcs_get_ids()

  ; set time default
  ; this gives delay in testing for started

  time = 1.0

  IF rcs_get_start() THEN BEGIN

    ; check skip

    WIDGET_CONTROL, ids.skiptime, GET_UVALUE=skip

    IF skip NE 0 THEN BEGIN

      WIDGET_CONTROL, ids.skiptime, GET_VALUE=skiptime

      IF skiptime[0] NE '' THEN skip = anytim2utc(skiptime[0])

    ENDIF

    ; read more data
    ; if not completed OK then indicate file blocked

    IF rcs_get_data(ids, SKIP=skip) THEN BEGIN
      WIDGET_CONTROL, ids.block, SET_BUTTON=0
      time = rcs_get_timer(0)
    ENDIF ELSE BEGIN
      WIDGET_CONTROL, ids.block, SET_BUTTON=1
      time = rcs_get_timer(1)
    ENDELSE

    ; process all stored data
    ; process HK first so that HK qualifiers are set up before SC stream processed

    rcs_get_hk_edbs, ids

    rcs_get_sc_edbs, ids

  ENDIF

  rcs_extract_state, ids

  rcs_in_state, ids

  ; keep going

  WIDGET_CONTROL, event.id, TIMER=time

END
