;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_TO_YYYYMMDD
;
; Purpose     :	Converts day from 'yymmdd' to 'yyyymmdd'.
;
; Explanation : Converts day from 'yymmdd' to 'yyyymmdd'.
;
; Use         : < yyyymmdd = rcs_to_yyyymmdd(yymmdd)>
;
; Inputs      : yymmdd  : STRARR of form 'yymmdd'
;
; Opt. Inputs : None.
;
; Outputs     : yyyymmdd  : STRARR of form 'yyyymmdd'
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 13/05/02
;                 Separated from rcs_sort_days.
;                 Corrected bug.
;
; Modified    : 
;
; Version     :	Version 0.0, 13/05/02
;-
;**********************************************************

FUNCTION rcs_to_yyyymmdd, yymmdd

  ; add century

  yyyymmdd = '20'+yymmdd

  list = WHERE(STRMID(yymmdd,0,1) EQ '9',count)

  IF count GT 0 THEN yyyymmdd[list] = '19'+yymmdd[list]

  RETURN, yyyymmdd

END
