;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_TRIM_IF
;
; Purpose     :	Applies time filter to IF data sets.
;
; Explanation : Applies time filter to IF data sets.
;
; Use         : < rcs_trim_if, ids >
;
; Inputs      : ids  : STRUCTURE containing widget ids.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 5/3/01
;
; Modified    : Version 0.1, 15/05/01
;                 Added CLEANBM2.
;               Version 0.2, 08/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.2, 08/02/02
;-
;**********************************************************

PRO rcs_trim_ifdata, times, header, data

  IF KEYWORD_SET(header) THEN BEGIN

    list = WHERE((data[0:header.npoints-1].time GE times[0]) AND $
                 (data[0:header.npoints-1].endtime LE times[1]), count)

    IF count EQ 0 THEN BEGIN

      header = 0
      data = 0

    ENDIF ELSE BEGIN

      data = data[list]

      header.npoints = count

      header.tstart = data[0].time

      header.tstop = data[count-1].endtime

    ENDELSE

  ENDIF

END

PRO rcs_trim_if, ids

  ; global common blocks

  COMMON rcs_extract_block, tmax, data_reset

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  ; get time limits

  tmin = rcs_get_tmin()

  IF tmin EQ 0 THEN RETURN

  tmax = rcs_get_tmax()

  times = rcs_cw_tslider(ids.base, tmin, tmax, tmin, tmax)

  ; if interactive then set hourglass

  IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

  ; trim IF data sets

  rcs_trim_ifdata, times, e3ddnm_header, e3ddnm_data

  rcs_trim_ifdata, times, ehist_header, ehist_data

  rcs_trim_ifdata, times, e3ddbm_header, e3ddbm_data

  rcs_trim_ifdata, times, epad_header, epad_data

  rcs_trim_ifdata, times, epad2_header, epad2_data

  rcs_trim_ifdata, times, ehk_header, ehk_data

  rcs_trim_ifdata, times, clean_header, clean_data

  rcs_trim_ifdata, times, cleanbm_header, cleanbm_data

  rcs_trim_ifdata, times, cleanbm2_header, cleanbm2_data

  rcs_trim_ifdata, times, espct_header, espct_data

  rcs_trim_ifdata, times, pedestal_header, pedestal_data

  rcs_trim_ifdata, times, i3dd_header_H, i3dd_data_H

  rcs_trim_ifdata, times, i3dd_header_He, i3dd_data_He

  rcs_trim_ifdata, times, i3dd_header_CNO, i3dd_data_CNO

  rcs_trim_ifdata, times, ipad_header, ipad_data

  rcs_trim_ifdata, times, hspct_header, hspct_data

  rcs_trim_ifdata, times, ispct_header_He, ispct_data_He

  rcs_trim_ifdata, times, ispct_header_CNO, ispct_data_CNO

  rcs_trim_ifdata, times, mtrx_header, mtrx_data

  rcs_trim_ifdata, times, sglbm_header, sglbm_data

  rcs_trim_ifdata, times, sgl01_header, sgl01_data

  rcs_trim_ifdata, times, sgl2_header, sgl2_data

  rcs_trim_ifdata, times, sgl3_header, sgl3_data

  rcs_trim_ifdata, times, hk1_header, hk1_data

  rcs_trim_ifdata, times, hk2_header, hk2_data

  rcs_trim_ifdata, times, hk4_header, hk4_data

  rcs_trim_ifdata, times, hk8_header, hk8_data

  rcs_trim_ifdata, times, hk32_header, hk32_data

  rcs_trim_ifdata, times, scinfo_header, scinfo_data

  ; find tmax

  tmax = rcs_get_tmax()

  ; set data reset

  data_reset = 3

END
