;+
; Project     :	CLUSTER -- RAPID
;
; Name        :	rcs_conv_structure
;
; Purpose     :	Returns structure used for coordinate conversion.
;
; Explanation : Returns structure used for coordinate conversion.
;
; Use         : <struct=rcs_conv_structure(win,xorig, yorig, xsize,ysize)>
;
; Inputs      : win   : LONG window number
;               xorig : LONG x origin
;               yorig : LONG y origin
;               xsize : LONG x dimension
;               ysize : LONG y dimension
;
; Opt. Inputs : None.
;
; Outputs     : conv : STRUCTURE containing coordinate conversion
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 31/05/01
;
; Modified    :	None.
;
; Version     :	Version 0.0, 31/05/01
;-
;**********************************************************

FUNCTION rcs_conv_structure, win, xorig, yorig, xsize, ysize

  structure = 0

  IF EXECUTE ( 'structure={SP_COORD_CONV_' + rcs_strtrim(xsize) + '_' + rcs_strtrim(ysize) +',' + $
               'win:win,' + $
               'xcoords:!X.S,' + $
               'ycoords:!Y.S,' + $
               'xwindow:!X.WINDOW,' + $
               'ywindow:!Y.WINDOW,' + $
               'clip:!P.CLIP,' + $
               'log:!Y.TYPE,' + $
               'xrange:!X.CRANGE,' + $
               'yrange:!Y.CRANGE,' + $
               'xorig:xorig,' + $
               'yorig:yorig,' + $
               'xsize:xsize,' + $
               'ysize:ysize,' + $
               'freq:FLTARR(xsize),' + $
               'data:FLTARR(xsize,ysize) }' ) THEN RETURN, structure

  rcs_message, 'Execute did not work', /TRACEBACK

END