;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_DISPLAY_IMAGE
;
; Purpose     :	Produces rebinned 2-D image of counts for y vs x.
;
; Explanation :	Associated with each column of the input image is a LUT number which defines the
;               bin positions of the y samples. This routine maps the input image into a new image
;               size in both x and y axes optionally taking into account the different column to
;               column y mapping i.e the different y channel sizes.
;               It also allows an option to shift each column to match pedestal positions.
;
; Use         : < ies_mk_image, y, x, luts, ch_positions, nchannels, ylo, yhi, xsize, ysize, $
;                               SHOWCH=showch, SHFTCH=shftch, LOG=log >
;
; Inputs      : y            : FLTARR(nchannels,npoints) data values at each sample point for each channel
;               x            : DBLARR(npoints) times for each sample in TAI format
;               luts         : BYTARR(npoints) LUT used for each sample point
;               ch_positions : FLTARR(2,nchannels,1,nluts) channel bin positions for each LUT.
;               nchannels    : LONG no. of y channels
;               ylo          : LONG low y axis value
;               yhi          : LONG high y axis value
;               xsize        : LONG x dimension of output array
;               ysize        : LONG y dimension of output array
;
; Opt. Inputs : None.
;
; Outputs     : y            : FLTARR(ysize,xsize) image
;
; Opt. Outputs:	None.
;
; Keywords    :/SHOWCH   : indicates whether to show real channel sizes or not
;              /SHFTCH   : indicates whether to shift data to match pedestal positions.
;                          Only available if showch is also set.
;              /LOG      : indicates logarithmic y axis display.
;
; Written     :	Version 0.0, Martin Carter, RAL, 2/6/95
;
; Modified    :	Version 0.1, MKC, 19/9/96
;                 Improved pedestal shift algorithm.
;                 Added DIV keyword.
;                 Added INTERP keyword.
;                 Shift pedestal to zero.
;                 Added ies rebin y.
;               Version 0.2, 11/11/96
;                 Removed DIV, new argument list for rebin_y
;               Version 0.3, 1/4/97
;                 Added LOG keyword.
;                 Changed yp to channel boundaries rather than channel centres.
;               Version 0.4, 28/4/97
;                 Corrected routine for case where more than 32767 data points.
;               Version 0.5, 2/3/98
;                 Removed interpolation option. Removed minimum argument.
;               Version 0.6, 9/12/00
;                 Adapted for RCS.
;               Version 0.7, 13/03/01
;                 Adjusted display position of image by y=+1 (ad hoc).
;         	Version 0.8, 09/07/02
;                 Used new routine ies_color_scale.
;
; Version     :	Version 0.8, 09/07/02
;-
;**********************************************************

PRO rcs_display_image, output_info, conv, x0, x1, y0, y1

  ; fix data within min and max

  image =conv.data[x0:x1,y0:y1]

  ; colour scale

  ies_color_scale, output_info, image

  ; check if rescaleable output device

  IF !D.FLAGS AND 1 THEN BEGIN

    ; white out zero elements for postscript plot

    IF !D.NAME EQ 'PS' THEN BEGIN

       ; list = WHERE ( yy EQ 0, count )

       ; IF count GT 0 THEN yy(list) = 255

    ENDIF

    ; convert offsets and sizes to normal coords

    xsize_n = (conv.xwindow[1]-conv.xwindow[0])*(x1-x0+1)/conv.xsize

    ysize_n = (conv.ywindow[1]-conv.ywindow[0])*(y1-y0+1)/conv.ysize

    x0_n = x0*(conv.xwindow[1]-conv.xwindow[0])/conv.xsize

    y0_n = y0*(conv.ywindow[1]-conv.ywindow[0])/conv.ysize

    ; plot array
    ; can use data coords but not as direct

    TV, image, conv.xwindow[0]+x0_n, conv.ywindow[0]+y0_n, XSIZE=xsize_n, YSIZE=ysize_n, /NORMAL, ORDER=0

  ENDIF ELSE BEGIN

    ; plot array

    ;TV, image, conv.xorig+x0, conv.yorig+y0, ORDER=0
    ; raised y position since image often shifted down relative to axes
    TV, image, conv.xorig+x0, conv.yorig+y0+1, ORDER=0

  ENDELSE

  ; overplot to neaten
  ; NB noclip did not work well enough

  PLOTS, [ conv.xwindow[0], conv.xwindow[1], conv.xwindow[1], conv.xwindow[0], conv.xwindow[0]], $
         [ conv.ywindow[0], conv.ywindow[0], conv.ywindow[1], conv.ywindow[1], conv.ywindow[0]], /NORMAL

END