;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_END_PLOT
;
; Purpose     :	Closes down graphics device for plot.
;
; Explanation : Closes down graphics device for plot.
;
; Use         : <rcs_end_plot, info >
;
; Inputs      : pageno  : INT page number of plot.
;               devname : STRING name of main device i.e 'X' or 'WIN'
;
; Opt. Inputs : None.
;
; Outputs     : Returns 0 if successful, 1 if unsuccessful.
;
; Opt. Outputs:	unit   : STRUCTURE containing output info.
;
; Keywords    : UPDATED : FLAG indicating plot has been written to.
;               VERSION : STRING containing production version
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, MKC, 10/12/00
;                 Added PNG format.
;               Version 0.2, 14/03/01
;                 Changed to output.
;                 Removed ids from rcs_text.
;               Version 0.3, 12/07/01
;                 Added UPDATED keyword.
;               Version 0.4, 20/07/01
;                 Added footnote.
;                 Added version keyword.
;               Version 0.5, 13/1/03
;                 Used rcs_plot_end
;               Version 0.6, 28/03/03
;                 Used ies_end_plot.
;
; Version     :	Version 0.6, 28/03/03
;-
;**********************************************************

PRO rcs_end_plot, info, UPDATED=updated, VERSION=version

  ON_IOERROR, IOERROR

  ; get character sizes in normal coords

  !P.CHARSIZE = 1

  x_chsize = get_chsize(/X)
  y_chsize = get_chsize(/Y)

  IF NOT KEYWORD_SET(version) THEN version = ''

  ; do footnotes

  footnote = 'vs '+STRING(version) + ' ' + ies_time(FORM=9)

  XYOUTS, 1.0 - STRLEN(footnote)*0.6*x_chsize, y_chsize*0.1, footnote, /NORMAL, CHARSIZE=0.6*!P.CHARSIZE

  footnote = strip_dirname(info.file)

  XYOUTS, 0.01, y_chsize*0.1, footnote, /NORMAL, CHARSIZE=0.6*!P.CHARSIZE

  IF NOT KEYWORD_SET(updated) THEN BEGIN

    rcs_text, 'NO DATA IN PLOT '+info.file, /OVERRIDE

    IF info.ps THEN DEVICE, /CLOSE

    SET_PLOT, info.dev

    ; set !p.region and position back again

    !P.REGION   = 0
    !P.POSITION = 0

  ENDIF ELSE BEGIN

  ies_end_plot, info.file, info.dev, POSTSCRIPT=info.ps, PNG=info.png, GIF=info.gif

  ENDELSE

RETURN

IOERROR:

  rcs_message, !ERR_STRING, /CONT, /TRACEBACK

  SET_PLOT, info.dev

END
