FUNCTION rcs_fit, y, TITLE=title, XMAX=xmax, QUIET=quiet

  ; suppress maths errors
  ; if curvefit fails to converge then get a divide by zero

  !EXCEPT = 0
  !QUIET = 1

  IF NOT KEYWORD_SET(quiet) THEN WINDOW, 0

  ; fits single Gaussian to different detectors for single integration time
  ; returns positions and FWHM
  ; y = FLTARR(nbins,ndetectors)

  IF NOT KEYWORD_SET(title) THEN title=''
  IF NOT KEYWORD_SET(xmax)  THEN xmax=60

  ; plot data and results

  ndetectors = (SIZE(y))[2]
  nbins      = 255

  w = FLTARR(2,ndetectors)

  IF NOT KEYWORD_SET(quiet) THEN WINDOW, 0

  FOR d = 0, ndetectors-1 DO BEGIN

      ; nb remove last data point since contains sum

      yy = REFORM(DOUBLE(y[0:254,d]))

      IF NOT KEYWORD_SET(quiet) THEN PLOT, /YLOG, yy, YRANGE=[1,1e6], XRANGE=[0,xmax], XTITLE='Bins', YTITLE='Counts', TITLE=title + ' det ' + rcs_strtrim(d), PSYM=2

      ; fits single Gaussian to data

      maxy = MAX(yy,maxx)

      yy = yy[(maxx-30)>0:(maxx+30)<(nbins-1)]

      a = DOUBLE([maxy,30<maxx,2])

      f = CURVEFIT ( FINDGEN(N_ELEMENTS(yy)), yy, 1/(yy>1.), a, FUNCTION_NAME='rcs_gausscv' )

      IF NOT KEYWORD_SET(quiet) THEN OPLOT, ((maxx-30)>0) + FINDGEN(nbins), f
      ; OPLOT, FINDGEN(nbins), ABS(f-yy), COLOR=200

      IF NOT KEYWORD_SET(quiet) THEN WAIT, 1

      a[1] = a[1] + ((maxx-30)>0)

      w[*,d] = a[1:2]

  ENDFOR

  ; convert to FWHM

  w[1,*] = w[1,*]*SQRT(alog(256))

  ; reinstate maths errors

  res = CHECK_MATH()

  !EXCEPT = 1
  !QUIET = 0

  RETURN, w

END
