PRO rcs_gausscv, x, aa, f, fder

  ; Fitting function for N Gaussians
  ; expects dimensions of aa to be multiple of three
  ; Used by CURVEFIT i.e
  ;  fit = CURVEFIT ( x, y, wgts, aa, sigs, FUNCTION_NAME = 'sgausscv' )

  ; x = list of npoint x values
  ; a = list of npar   parameter values
  ; fder = (npoints,npar) array of partial derivatives

  ; n gauss curves

  n = N_ELEMENTS(aa)/3

  a = REFORM(aa,3,n)

;  print, a
  ; print,''

  ; form partial derivatives

  IF ( N_PARAMS() GT 3 ) THEN fder = DBLARR( N_ELEMENTS(x), N_ELEMENTS(aa) )

  f = 0.0

  FOR k = 0, n-1 DO BEGIN

    IF a(2,k) NE 0.0 THEN z = (x-a(1,k))/a(2,k) ELSE z = 10

    zz = ( z^2 ) < 100

    ez = EXP(-zz/2)

    y  = a(0,k)*ez

    f = f + y

    IF ( N_PARAMS() GT 3 ) THEN BEGIN

      fder(*,k*3)  = ez

      IF a(2,k) NE 0.0 THEN fder(*,k*3+1)  = y*z/a(2,k)

      fder(*,k*3+2)  = fder(*,k*3+1)*z

    ENDIF

  ENDFOR

;  OPLOT, x, f

END
