;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_GET_COLOR
;
; Purpose     :	Gets prominent colour for display.
;
; Explanation :	Gets a colour corresponding to supplied index.
;
; Use         : < color = rcs_get_color(k) >
;
; Inputs      : k            : INT index of color
;
; Opt. Inputs : None.
;
; Outputs     : color : INT color index 0:255
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    : Version 0.1, 16/03/01
;                 Added WYSIWYG.
;               Version 0.2, 14/02/02
;                 Changed colors to conform to CLUSTER spec.
;               Version 0.3, 09/07/02
;                 Modified ies_ncolors.
;               Version 0.4, 08/08/02
;                 Swapped colors 3 and 9 around to get more visible color for SC3.
;
; Version     :	Version 0.4, 08/08/02
;-
;**********************************************************

FUNCTION rcs_get_color, k

  ; same as ies_get_color but allows different set of colors

  ; set up colors to be used
  ; change white to black if postscript

  IF !D.NAME EQ 'PS' THEN $
    colors = [0,240,150,80,208,192,170,112,96,30,64,48,16] $
  ELSE $
    colors = [256,240,150,80,208,192,170,112,96,30,64,48,16]

  IF k LT N_ELEMENTS(colors) THEN col = colors[k] ELSE col = colors[0]

  col = ((ies_ncolors()-1L)*col)/256

  RETURN, col

END

