;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_GET_CONV
;
; Purpose     :	Get coord conversion for panel defined by id.
;
; Explanation :	Get coord conversion for panel defined by id.
;
; Use         : < conv = rcs_get_conv (id) >
;
; Inputs      : id : LONG id identifying panel.
;
; Opt. Inputs : None.
;
; Outputs     : conv : STRUCTURE containing coord conversion for panel.
;
; Opt. Outputs:	None.
;
; Keywords    : NO_COPY : FLAG passed to widget control.
;
; Written     :	Version 0.0, 30/05/01
;
; Modified    :
;
; Version     : Version 0.0, 30/05/01
;-
;**********************************************************

FUNCTION rcs_get_conv, id, NO_COPY=no_copy

  COMMON rcs_coord_conversion_local, n_ids, sp_ids, sp_convs, lp_ids, lp_convs

  ; check if widget or non-widget

  IF id GT 0 THEN BEGIN

    ; widget ID with uvalue used to store conversion

    WIDGET_CONTROL, id, GET_UVALUE=conv, NO_COPY=no_copy

  ENDIF ELSE BEGIN

    ; non widget id, conversion stored in COMMON block
    ; find ID

    sp = 1

    list = WHERE ( sp_ids EQ id, count)

    IF count EQ 0 THEN BEGIN

      list = WHERE ( lp_ids EQ id, count)

      sp = 0

    ENDIF

    IF count NE 1 THEN rcs_message,/IMPLEMENTATION

    IF sp THEN conv = sp_convs[list[0]] ELSE conv = lp_convs[list[0]]

  ENDELSE

  RETURN, conv

END
