;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_GET_LIST
;
; Purpose     :	Gets latest times for display.
;
; Explanation :	Gets latest times for display for each of the data common blocks.
;               Checks whether the last data point is complete for each data set.
;
; Use         : < list = rcs_get_list( header, data, position, new_position, count)>
;
; Inputs      : header        : STRUCTURE IF data info
;               data          : STRUCTURE IF data
;               position      : DOUBLE TAI time of previous last point plotted
;
; Opt. Inputs : None.
;
; Outputs     : list          : LONARR indices of new points
;                               -1 if no new points
;               new_position  : DOUBLE TAI time of last point for plotting
;               count         : LONG no of new points
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/09/00
;
; Modified    :
;
; Version     : Version 0.0, 17/09/00
;-
;**********************************************************

FUNCTION rcs_get_list, header, data, position, new_position, count

  ; initialize count

  count = 0

  ; determine end time of data

  IF KEYWORD_SET(header) THEN BEGIN

    ; check if last point completed

    IF (data[header.npoints-1].flag AND '80'X) EQ 0 THEN BEGIN

      new_position = data[header.npoints-1].endtime

      IF new_position GT position THEN BEGIN

        list = WHERE(data[0:header.npoints-1].endtime GT position, count)

        RETURN, list

      ENDIF

    ENDIF ELSE IF header.npoints GT 1 THEN BEGIN

      new_position = data[header.npoints-2].endtime

      IF new_position GT position THEN BEGIN

        list = WHERE(data[0:header.npoints-2].endtime GT position, count)

        RETURN, list

      ENDIF

    ENDIF

  ENDIF

  RETURN, -1

END
