;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_GET_POSITIONS
;
; Purpose     :	Initializes or resets positions structure..
;
; Explanation :	The positions structure contains the latest completed sample corresponding
;               to each of the display panels. This routine initializes the positions structure
;               or resets the elements of the structure to zero. Some of the panels use overlap
;               plotting so that on redrawing the window some of the data may already be plotted.
;               these are not reset unless a data reset is requested.
;
; Use         : < rcs_get_positions, positions, RESET=reset, DATA_RESET=data_reset >
;
; Inputs      : positions : STRUCTURE containing TAI end times of last complete data sample
;                           for each data set plotted in panels.
;
; Opt. Inputs : None.
;
; Outputs     : positions : STRUCTURE initialized or reset
;
; Opt. Outputs:	None.
;
; Keywords    : RESET      : FLAG indicating reset rather than initialization required
;               DATA_RESET : FLAG indicating full reset required
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 6/2/01
;                 Added ESPCT IF data set.
;                 Changed cent to pedestal.
;               Version 0.2, 15/05/01
;                 Added CLEANBM2.
;               Version 0.3, 25/05/01
;                 Added HKSUN and HKRAT.
;               Version 0.4, 31/05/01
;                 Added STABM and STOBM.
;               Version 0.5, 08/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.5, 08/02/02
;-
;**********************************************************

PRO rcs_get_positions, positions, RESET=reset, DATA_RESET=data_reset

  ; set up positions structure
  ; every panel or panel group has its own positions tag
  ; where more than one data set contributes to a panel each has its own tag for that panel
  ; thus positions tags are different from panel_ids tags.

  IF KEYWORD_SET(RESET) THEN BEGIN

    ; reset plot positions for those panels not using overlap

    positions.e3dd_luts = 0.0d0
    positions.ehist_fit = 0.0d0
    positions.ehist_luts = 0.0d0
    positions.ehk = 0.0d0
    positions.hk1_luts = 0.0d0
    positions.hk1_flag = 0.0d0
    positions.hk32_flag = 0.0d0
    positions.tmp = 0.0d0
    positions.hv = 0.0d0
    positions.hksun = 0.0d0
    positions.hkrat = 0.0d0
    positions.mtrx     = 0.0d0
    positions.sglbm    = 0.0d0
    positions.sgl01    = 0.0d0
    positions.sgl1     = 0.0d0
    positions.sgl2     = 0.0d0
    positions.sgl3     = 0.0d0
    positions.epad  = 0.0d0
    positions.epad2  = 0.0d0
    positions.ipad  = 0.0d0
    positions.hkfcr = 0.0d0
    positions.sta = 0.0d0
    positions.sto = 0.0d0
    positions.stabm = 0.0d0
    positions.stobm = 0.0d0
    positions.subc = 0.0d0
    positions.scflag = 0.0d0
    positions.pedestal = 0.0d0

    ; reset plot positions for those panels using overlap if data reset

    IF KEYWORD_SET(data_reset) THEN BEGIN

      positions.e3dd    = 0.0d0
      positions.e3ddbm  = 0.0d0
      positions.ehist   = 0.0d0
      positions.i3dd    = 0.0d0
      positions.hspct   = 0.0d0
      positions.ispct   = 0.0d0
      positions.clean   = 0.0d0
      positions.cleanbm = 0.0d0
      positions.cleanbm2= 0.0d0
      positions.espct   = 0.0d0
;rcs_message,"data reset",/informational
    ENDIF

  ENDIF ELSE BEGIN

    positions = {e3dd:0.0d0, e3ddbm:0.0d0, e3dd_luts:0.0d0, ehist:0.0d0, ehist_fit:0.0d0, ehist_luts:0.0d0, $
                 ehk:0.0d0, hk1_luts:0.0d0, hk1_flag:0.0d0,  hk32_flag:0.0d0, tmp:0.0d0, epad:0.0d0, epad2:0.0d0, i3dd:0.0d0, ipad:0.0d0, ispct:.0d0, hspct:0.0d0, $
                 mtrx:0.0d0, sglbm:0.0d0, sgl01:0.0d0, sgl1:0.0d0, sgl2:0.0d0, sgl3:0.0d0, hv:0.0d0, hkrat:0.0d0, hksun:0.0d0, espct:0.0d0, $
                 hkfcr:0.0d0, sta:0.0d0, sto:0.0d0, stabm:0.0d0, stobm:0.0d0, subc:0.0d0, scflag:0.0d0, clean:0.0d0, cleanbm:0.0d0, cleanbm2:0.0d0, pedestal:0.0d0 }

  ENDELSE

END
