;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_GET_SECTORS
;
; Purpose     :	Returns sector positions.
;
; Explanation :	Returns sector positions.
;
; Use         : < output_chans = rcs_get_sectors(nsectors, SHOWCH=showch) >
;
; Inputs      : nsectors  : INT no of sectors
;
; Opt. Inputs : None.
;
; Outputs     : output_chans : FLTARR(2,nsectors) sector bounadries.
;
; Opt. Outputs:	None.
;
; Keywords    : SHOWCH : FLAG indicating output in degrees.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :
;
; Version     :	Version 0.0, 17/9/00
;-
;**********************************************************

FUNCTION rcs_get_sectors, nsectors, SHOWCH=showch

  ; define sector positions

  output_chans = FLTARR( 2, nsectors)

  output_chans[0,*] = FINDGEN(nsectors)

  output_chans[1,*] = (1+FINDGEN(nsectors))

  IF KEYWORD_SET(showch) THEN output_chans = output_chans/nsectors*360.0

  RETURN, output_chans

END
