;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_GET_TEND
;
; Purpose     :	Get time of last completed sample in IF data set.
;
; Explanation :	The last sample may still be updated if the data is subcommutated.
;               Byte 2 in data.flag contains a counter indicating how many  data packets
;               still needed. When this is zero the sample is completed. If no completed
;               data then zero is returned else returns the end time of the last completed
;               data sample.
;
; Use         : < time = rcs_get_tend (header, data) >
;
; Inputs      : header : STRUCTURE containing IF data set info
;               data   : STRUCTURE ARRAY containign IF data
;
; Opt. Inputs : None.
;
; Outputs     : timne  : DOUBLE TAI end time of last completed data sample or zero.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.2, 14/2/01
;                 Renamed routine.
;
; Version     : Version 0.2, 14/2/01
;-
;**********************************************************

FUNCTION rcs_get_tend, header, data

  ; determine end time of data

  IF KEYWORD_SET(header) THEN BEGIN

    ; check if last point completed

    IF ISHFT(data[header.npoints-1].flag, -8) EQ 0 THEN BEGIN
      RETURN, data[header.npoints-1].endtime
    ENDIF ELSE IF header.npoints GT 1 THEN BEGIN
      RETURN, data[header.npoints-2].endtime
    ENDIF ELSE BEGIN
      RETURN, 0.0d0
    ENDELSE

  ENDIF

  RETURN, 0.0d0

END
