;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_GET_TMAX
;
; Purpose     :	Gets latest time in IF data sets.
;
; Explanation :	Gets latest time in IF data sets.
;
; Use         : < tmax = rcs_get_tmax() >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : tmax : DOUBLE TAI end time of latest sample in ID data sets.
;
; Opt. Outputs:	None.
;
; Keywords    : NO_HK : FLAG indicating should exclude HK data from latest time
;
; Modified    : Version 0.1, 6/2/01
;                 Added pedestals and espct IF data set.
;               Version 0.2, 14/2/01
;                 Changed to rcs_get_tend
;               Version 0.3, 15/05/01
;                 Added CLEANBM2.
;               Version 0.3, 08/02/02
;                 Added EPAD2.
;
; Version     :	Version 0.3, 08/02/02
;-
;**********************************************************

FUNCTION rcs_get_tmax, NO_HK=no_hk

  ; global common blocks

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  ; determine end times of last data

  IF KEYWORD_SET(no_hk) THEN BEGIN

    RETURN, MAX([ rcs_get_tend(e3ddnm_header,e3ddnm_data) , $
                  rcs_get_tend(clean_header,clean_data) , $
                  rcs_get_tend(cleanbm_header,cleanbm_data) , $
                  rcs_get_tend(cleanbm2_header,cleanbm2_data) , $
                  rcs_get_tend(pedestal_header,pedestal_data) , $
                  rcs_get_tend(e3ddbm_header,e3ddbm_data) , $
                  rcs_get_tend(ehist_header,ehist_data) , $
                  rcs_get_tend(epad_header,epad_data) , $
                  rcs_get_tend(epad2_header,epad2_data) , $
                  rcs_get_tend(i3dd_header_H,i3dd_data_H) , $
                  rcs_get_tend(i3dd_header_He,i3dd_data_He) , $
                  rcs_get_tend(i3dd_header_CNO,i3dd_data_CNO) , $
                  rcs_get_tend(ipad_header,ipad_data) , $
                  rcs_get_tend(espct_header,espct_data) , $
                  rcs_get_tend(hspct_header,hspct_data) , $
                  rcs_get_tend(ispct_header_He,ispct_data_He) , $
                  rcs_get_tend(ispct_header_CNO,ispct_data_CNO) , $
                  rcs_get_tend(mtrx_header,mtrx_data) , $
                  rcs_get_tend(sglbm_header,sglbm_data) , $
                  rcs_get_tend(sgl01_header,sgl01_data) , $
                  rcs_get_tend(sgl2_header,sgl2_data) , $
                  rcs_get_tend(sgl3_header,sgl3_data) , $
                  rcs_get_tend(scinfo_header,scinfo_data) ] )

  ENDIF ELSE BEGIN

    RETURN, MAX([ rcs_get_tend(e3ddnm_header,e3ddnm_data) , $
                  rcs_get_tend(clean_header,clean_data) , $
                  rcs_get_tend(cleanbm_header,cleanbm_data) , $
                  rcs_get_tend(cleanbm2_header,cleanbm2_data) , $
                  rcs_get_tend(pedestal_header,pedestal_data) , $
                  rcs_get_tend(e3ddbm_header,e3ddbm_data) , $
                  rcs_get_tend(ehist_header,ehist_data) , $
                  rcs_get_tend(epad_header,epad_data) , $
                  rcs_get_tend(epad2_header,epad2_data) , $
                  rcs_get_tend(ehk_header,ehk_data) , $
                  rcs_get_tend(i3dd_header_H,i3dd_data_H) , $
                  rcs_get_tend(i3dd_header_He,i3dd_data_He) , $
                  rcs_get_tend(i3dd_header_CNO,i3dd_data_CNO) , $
                  rcs_get_tend(ipad_header,ipad_data) , $
                  rcs_get_tend(espct_header,espct_data) , $
                  rcs_get_tend(hspct_header,hspct_data) , $
                  rcs_get_tend(ispct_header_He,ispct_data_He) , $
                  rcs_get_tend(ispct_header_CNO,ispct_data_CNO) , $
                  rcs_get_tend(mtrx_header,mtrx_data) , $
                  rcs_get_tend(sglbm_header,sglbm_data) , $
                  rcs_get_tend(sgl01_header,sgl01_data) , $
                  rcs_get_tend(sgl2_header,sgl2_data) , $
                  rcs_get_tend(sgl3_header,sgl3_data) , $
                  rcs_get_tend(hk1_header,hk1_data) , $
                  rcs_get_tend(hk2_header,hk2_data) , $
                  rcs_get_tend(hk4_header,hk4_data) , $
                  rcs_get_tend(hk8_header,hk8_data) , $
                  rcs_get_tend(hk32_header,hk32_data) , $
                  rcs_get_tend(scinfo_header,scinfo_data) ] )

  ENDELSE

END
