;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_GET_TSTART
;
; Purpose     :	Get time of first sample in IF data set.
;
; Explanation :	Get time of first sample in IF data set.
;
; Use         : < time = rcs_get_tstart (header, data) >
;
; Inputs      : header : STRUCTURE containing IF data set info
;               data   : STRUCTURE ARRAY containign IF data
;
; Opt. Inputs : None.
;
; Outputs     : time  : DOUBLE TAI end time of first data sample or zero.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.2, 14/2/01
;                 Renamed routine.
;
; Version     : Version 0.0, 17/9/00
;-
;**********************************************************

FUNCTION rcs_get_tstart, header, data

  ; determine end time of data

  IF KEYWORD_SET(header) THEN BEGIN

    RETURN, header.tstart

  ENDIF ELSE BEGIN

    RETURN, 0.0d0

  ENDELSE

END
