;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_GOOD_DATA
;
; Purpose     :	Gets data within time range specified.
;
; Explanation :	Gets data within time range specified. Optionally checks data.flag for invalid data
;               and removes from list.
;
; Use         : < list = rcs_good_data( header, data, tstart, tstop, NOBAD=nobad, COUNT=count) >
;
; Inputs      : header       : STRUCTURE IF data set header information
;               data         : STRUCTURE ARRAY IF data set data
;               tstart       : DOUBLE TAI time of start of period of interest
;               tstop        : DOUBLE TAI time of end of period of interest
;
; Opt. Inputs : None.
;
; Outputs     : list : LONARR indices of data within period of interest
;                      If no data then returns [-1].
;
; Opt. Outputs:	None.
;
; Keywords    : NO_BAD  : FLAG indicates should omit any data with bad data flags.
;               COUNT   : LONG no of data samples returned
;               LIST    : LONARR list of samples to use to bypass time selection
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 07/02/02
;                 Used external routine to check for good data.
;               Version 0.2, 17/04/02
;                 Added removal of points before time gap.
;
; Version     :	Version 0.2, 17/04/02
;-
;**********************************************************

 FUNCTION rcs_good_data, header, data, tstart, tstop, NOBAD=nobad, COUNT=count, LIST=list, REMOVE=remove

  ; initialize count

  count = 0

  ; return if no data

  IF NOT KEYWORD_SET(header) THEN RETURN, [-1]

  ; check if list supplied

  IF NOT KEYWORD_SET(list) THEN BEGIN

    ; only plot times in plot window

    list = WHERE(data.endtime GT tstart AND data.time LT tstop, count)

    IF count EQ 0 THEN RETURN, [-1]

  ENDIF ELSE BEGIN

    count = N_ELEMENTS(list)

  ENDELSE

  ; remove gap points

;  IF KEYWORD_SET(remove) THEN BEGIN

;    ; default to 1 sec for now

 ;   elist = WHERE(data[list[1:*]].time-data[list].endtime GT 1, ecount)

;    IF ecount GT 0 THEN BEGIN

    

;    ENDIF

;  ENDIF

  ; only good data

  IF KEYWORD_SET(nobad) THEN BEGIN

     good_list= ies_good_data ( data[list].flag, COUNT=count)

     IF count EQ 0 THEN RETURN, [-1]

     ; index back to data

     list = list[good_list]

  ENDIF

  RETURN, list

END
