;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_HIST_FILENAME
;
; Purpose     :	Generates filename for HIST data.
;
; Explanation : Generates filename for HIST data.
;               Either defaults to directory name
;               '../RAPID_1/surveyname/' or uses parent directory name.
;
; Use         : < res = rcs_hist_filename ( sc, time, mode, PS=ps, PNG=png, GIF=gif) >
;
; Inputs      : sc   : STRING character giving S/C.
;               time : DOUBLE TAI time
;               mode : INT value indicating integration time mode.
;
; Opt. Inputs : None.
;
; Outputs     : res : INT flag indicating error status
;                       0 = error
;                       1 = ok
;
; Opt. Outputs: None.
;
; Keywords    : PNG : STRING indicating PNG fileroot
;               GIF : STRING indicating GIF filerootfileroot
;               PS  : STRING indicating postscript fileroot
;
; Written     :	Version 0.0, 26/1/01
;
; Modified    :	Version 0.1, 20/05/02
;                 Changed name for batch output.
;               Version 0.2, 30/08/03
;                 Changed to RCS environment variables for PNG and GIF.
;               Version 0.3, 09/10/03
;                 Used ies get dir.
;               Version 0.4, 07/11/03
;                 Used rcs get subdir.
;
; Version     :	Version 0.4, 07/11/03
;-
;**********************************************************

FUNCTION rcs_hist_filename, sc, time, mode, PS=ps, PNG=png, GIF=gif

  ; if widget_update called from batch process then
  ; png='.../RAPID_1/hist/yymmdd.png'
  ; if widget_update called from rcs_widget_event then png=1 for first plot
  ; then subsequent plots have whatever png is set up as

  IF KEYWORD_SET(png) THEN BEGIN

    ; check if filename defined already

    IF datatype(png) EQ 'STR' THEN BEGIN

      ; get root

      root = rcs_find_parent(png)

    ENDIF ELSE BEGIN

      ; called from RCS tool
      ; gets put into png/RAPID_n/hist_file

      root = rcs_get_subdir('PNG',sc)

      IF NOT KEYWORD_SET(root) THEN RETURN, 0

    ENDELSE

    png = concat_dir(root, 'hist_mode_' + rcs_strtrim(mode) + '_' + anytim2cal ( time, FORM=8) + '.png')

  ENDIF

  IF KEYWORD_SET(gif) THEN BEGIN

    ; check if filename defined already

    IF datatype(gif) EQ 'STR' THEN BEGIN

      ; get root

      root = rcs_find_parent(gif)

    ENDIF ELSE BEGIN

      root = rcs_get_subdir('GIF',sc)

      IF NOT KEYWORD_SET(root) THEN RETURN, 0

    ENDELSE

    gif = concat_dir(root, 'hist_mode_'+ rcs_strtrim(mode) + '_' + anytim2cal ( time, FORM=8) + '.gif')

  ENDIF

  IF KEYWORD_SET(ps) THEN BEGIN

    ; check if filename defined already

    IF datatype(ps) EQ 'STR' THEN BEGIN

      ; get root

      root = rcs_find_parent(ps)

    ENDIF ELSE BEGIN

      root = rcs_get_subdir('PS',sc)

      IF NOT KEYWORD_SET(root) THEN RETURN, 0

    ENDELSE

    ps = concat_dir(root, 'hist_mode_' + rcs_strtrim(mode) + '_' + anytim2cal ( time, FORM=8) + '.ps')

  ENDIF

  RETURN, 1

END
