;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_HIST_HTML
;
; Purpose     :	Generates HTML for HIST data.
;
; Explanation : Generates HTML for HIST data.
;               The output may be edited easily into an HTML table.
;
; Use         : < rcs_hist_html, sc, file, time, mode, PS=ps, PNG=png, GIF=gif >
;
; Inputs      : sc   : STRING character giving S/C.
;               file : STRING hist html file name.
;               time : DOUBLE TAI time
;               mode : INT value indicating integration time mode.
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    : PNG : STRING indicating PNG fileroot
;               GIF : STRING indicating GIF filerootfileroot
;               PS  : STRING indicating postscript fileroot
;
; Written     :	Version 0.0, 20/05/02
;
; Modified    :	Version 0.1, 09/07/02
;                 Added print comment.
;                 Added WIN keyword.
;               Version 0.2, 30/08/03
;                 Changed to RCS environment variables for PNG and GIF.
;               Version 0.3, 09/10/03
;                 Used ies get dir.
;               Version 0.4, 07/11/03
;                 Used rcs get subdir to allow subdirectory to be created.
;                 Added fiel to argument list so name only gets printed once
;
; Version     :	Version 0.4, 07/11/03
;-
;**********************************************************

PRO rcs_hist_html, sc, file, time, mode, PS=ps, PNG=png, GIF=gif, WIN=win

  ON_IOERROR, ioerror

  IF KEYWORD_SET(png) THEN BEGIN

    name = png

  ENDIF ELSE IF KEYWORD_SET(gif) THEN BEGIN

    name = gif

  ENDIF ELSE IF KEYWORD_SET(ps) THEN BEGIN

    name = ps

  ENDIF ELSE IF KEYWORD_SET(win) THEN BEGIN

    RETURN

  ENDIF ELSE BEGIN

    rcs_message, 'WARNING, INVALID HISTOGRAM FILE NAME', /INFORMATIONAL

    RETURN

  ENDELSE

  ; NB need APPEND else will only get last file

  OPENW, unit, file, /GET_LUN, /APPEND

  PRINTF, unit, '<td><a href="../survey/RAPID_'+sc+'/xhist/'+strip_dirname(name)+ $
    '"> '+(['2 us','5 us', '15 us', '50 us'])[mode]+' '+anytim2cal(time)+'</a></td>'

  FREE_LUN, unit

  RETURN

ioerror :

  IF KEYWORD_SET(unit) THEN FREE_LUN, unit

  rcs_message, !ERR_STRING, /INFORMATIONAL

  RETURN

END
