;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_PANEL
;
; Purpose     :	Creates a window containing a number of drawing widget panels.
;
; Explanation :	Uses timer events to update panels.
;
; Use         : < ids = rcs_panel(output_info) >
;
; Inputs      : output_info  : Structure containing directions for panel displays.
;
; Opt. Inputs : None.
;
; Outputs     : ids : STRUCTURE containing widget ids.
;
; Opt. Outputs:	None.
;
; Keywords    : NONWIDGET : FLAG indicating should create dummy widget for non-widget output.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, MKC, 10/12/00
;                 Added PNG format.
;                 Added set parameters command.
;               Version 0.2, 7/2/01
;                 Added REDRAW, SET PLOT PARAMETERS options.
;                 Changed centroid to pedestal.
;                 Added ESPCT.
;               Version 0.3, 16/03/01
;                 Changed SET keyword in ies_ncolors to WYSIWYG.
;               Version 0.4, 15/05/01
;                 Added CLEANBM2.
;               Version 0.5, 25/05/01
;                 Added HKSUN and HKRAT.
;               Version 0.6, 30/05/01
;                 Added COMMON block for non-widget plots.
;                 Added STABM and STOBM.
;               Version 0.7, 08/02/02
;                 Added EPAD2.
;               Version 0.8, 09/07/02
;                 Removed .ncolors tag.
;
; Version     :	Version 0.8, 09/07/02
;-
;**********************************************************

FUNCTION rcs_panel, output_info, NONWIDGET=nonwidget

  COMMON rcs_coord_conversion_local, n_ids, sp_ids, sp_convs, lp_ids, lp_convs

  ; NB need to reset values specific to previous context

  output_info.tstart = 0.0d0

  output_info.tstop  = 0.0d0

  output_info.tmax   = 0.0d0

  ; get machine dependent values

  res = rcs_machine(output_info.noutputs)

  ; set up panel ids structure

  panel_ids = {info:0L, positions:0L, e3dds:LONARR(9), e3ddbms:LONARR(9), epads:LONARR(6), epad2s:LONARR(6), lut:0L, ehist:0L, $
                ehks:LONARR(9), scflag:0L, hkflag:0L, tmp:0L, fit:LONARR(3), i3dds:LONARR(36), ipads:LONARR(6), $
                hspct:0L, ispctHe:0L, ispctCNO:0L, sglbm:LONARR(3), sgl01:0L, sgl1:0L, sgl2:0L, sgl3:0L, hv:0L, hksun:0L, hkrat:0L, $
                cleans:LONARR(9), cleanbms:LONARR(9), cleanbm2s:LONARR(9), pedestals:LONARR(9), espct:0L, m:LONARR(2), hkfcr:0L, $
                sta:0L, sto:0L, stabm:0L, stobm:0L, subc:0L }

  IF NOT KEYWORD_SET(nonwidget) THEN BEGIN

    ; set up other widgets
    ; use uvalue to store positions

    rcs_get_positions, positions

    base  = WIDGET_BASE ( TITLE=output_info.title, /COL, UVALUE=0L)

    ; set up panel buttons
    ; use uvalue to store output_info

    panel_ids.info = WIDGET_BASE ( base, UVALUE=output_info, /ROW)

    dummy = WIDGET_BUTTON(panel_ids.info, VALUE='SET TIME RANGE')

    dummy = WIDGET_BUTTON(panel_ids.info, VALUE='SET PLOT PARAMETERS')

    dummy = WIDGET_BUTTON(panel_ids.info, VALUE='PAUSE')

    items = [  '1\PRINT',      $
               '0\WIN',        $
               '0\PS',         $
               '0\GIF',        $
               '2\PNG']

    dummy = CW_PDMENU ( panel_ids.info, items, /RETURN_FULL_NAME)

    dummy = WIDGET_BUTTON(panel_ids.info, VALUE='REDRAW')

    dummy = WIDGET_BUTTON(panel_ids.info, VALUE='QUIT')

    ; set up widget base
    ; check to see if actually need scroll bars since cause extra space in
    ; window if not needed.
    ; no events downstream of here except timer events

    IF res.ysize LE res.scr_ysize THEN BEGIN

      ; dont need scroll bars

      panel_ids.positions = WIDGET_BASE ( base, /COL, /FRAME, UVALUE=positions, /NO_COPY, EVENT_PRO='rcs_panel_timer')

    ENDIF ELSE BEGIN

      ; scroll bars required

      panel_ids.positions = WIDGET_BASE ( base, /COL, /SCROLL, YSIZE=res.ysize, XSIZE=res.xsize, X_SCROLL_SIZE=res.scr_xsize, Y_SCROLL_SIZE=res.scr_ysize, $
                               /FRAME, UVALUE=positions, /NO_COPY, EVENT_PRO='rcs_panel_timer')

    ENDELSE

  ENDIF ELSE BEGIN

    ; initialize non-widget COMMON block

    n_ids = 0

  ENDELSE

  panels = panel_ids.positions

  ; set up panels
  ; NB UVALUES of panels used for coordinate conversion

  ; make row group for e3dd

  FOR k = 0, output_info.e3dd-1 DO panel_ids.e3dds[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for e3ddbm

  FOR k = 0, output_info.e3ddbm-1 DO panel_ids.e3ddbms[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for clean

  FOR k = 0, output_info.clean-1 DO panel_ids.cleans[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for cleanbm

  FOR k = 0, output_info.cleanbm-1 DO panel_ids.cleanbms[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for cleanbm2

  FOR k = 0, output_info.cleanbm2-1 DO panel_ids.cleanbm2s[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for espct

  IF output_info.espct THEN panel_ids.espct = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for pedestal

  FOR k = 0, output_info.pedestal-1 DO panel_ids.pedestals[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for ehist

  IF output_info.ehist THEN panel_ids.ehist = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for fit

  FOR k= 0, output_info.fit-1 DO panel_ids.fit[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for epad

  FOR k = 0, output_info.epad-1 DO panel_ids.epads[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for epad2

  FOR k = 0, output_info.epad2-1 DO panel_ids.epad2s[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for m

  FOR k = 0, output_info.m-1 DO panel_ids.m[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for ehk

  FOR k = 0, output_info.ehk-1 DO panel_ids.ehks[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for luts

  IF output_info.luts THEN panel_ids.lut = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for scflag

  IF output_info.scflag THEN panel_ids.scflag = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for subc

  IF output_info.subc THEN panel_ids.subc = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for hkflag

  IF output_info.hkflag THEN panel_ids.hkflag = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for hkfcr

  IF output_info.hkfcr THEN panel_ids.hkfcr = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for temperature

  IF output_info.tmp THEN panel_ids.tmp = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for i3dd

  FOR k = 0, output_info.i3dd-1 DO panel_ids.i3dds[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for ipad

  FOR k = 0, output_info.ipad-1 DO panel_ids.ipads[k] = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for hspct

  IF output_info.hspct THEN panel_ids.hspct = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for ispct

  IF output_info.ispctHe  THEN panel_ids.ispctHe  = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  IF output_info.ispctCNO THEN panel_ids.ispctCNO = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for sglbm

  FOR k = 0, output_info.sglbm-1 DO panel_ids.sglbm[k]  = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for stabm

  IF output_info.stabm THEN panel_ids.stabm = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for stobm

  IF output_info.stobm THEN panel_ids.stobm = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for sgl01

  IF output_info.sgl01  THEN panel_ids.sgl01  = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for sta

  IF output_info.sta  THEN panel_ids.sta  = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for sto

  IF output_info.sto  THEN panel_ids.sto = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for sgl1

  IF output_info.sgl1  THEN panel_ids.sgl1 = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for sgl2

  IF output_info.sgl2  THEN panel_ids.sgl2 = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for sgl3

  IF output_info.sgl3 THEN panel_ids.sgl3  = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for hksun

  IF output_info.hksun THEN panel_ids.hksun  = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for hkrat

  IF output_info.hkrat THEN panel_ids.hkrat  = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; make row group for hv

  IF output_info.hv THEN panel_ids.hv = rcs_panel_draw_widget( panels, res.pxsize, res.pysize, NONWIDGET=nonwidget)

  ; if non widget return

  IF KEYWORD_SET(nonwidget) THEN RETURN, panel_ids

  ; realize the widget

  WIDGET_CONTROL, base, /REALIZE

  ; check all panels realized successfully

  invalid = 1 - WIDGET_INFO(base,/VALID_ID)

  invalid = invalid + 1 - WIDGET_INFO(panel_ids.info,/VALID_ID)

  invalid = invalid + 1 - WIDGET_INFO(panel_ids.positions,/VALID_ID)

  FOR k = 0, output_info.e3dd-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.e3dds[k],/VALID_ID)

  FOR k = 0, output_info.e3ddbm-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.e3ddbms[k],/VALID_ID)

  FOR k = 0, output_info.clean-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.cleans[k],/VALID_ID)

  FOR k = 0, output_info.cleanbm-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.cleanbms[k],/VALID_ID)

  FOR k = 0, output_info.cleanbm2-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.cleanbm2s[k],/VALID_ID)

  IF output_info.espct THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.espct,/VALID_ID)

  FOR k = 0, output_info.pedestal-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.pedestals[k],/VALID_ID)

  IF output_info.ehist THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.ehist,/VALID_ID)

  FOR k =0, output_info.fit-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.fit[k],/VALID_ID)

  FOR k = 0, output_info.epad-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.epads[k],/VALID_ID)

  FOR k = 0, output_info.epad2-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.epad2s[k],/VALID_ID)

  FOR k = 0, output_info.ehk-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.ehks[k],/VALID_ID)

  IF output_info.tmp THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.tmp,/VALID_ID)

  IF output_info.luts THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.lut,/VALID_ID)

  IF output_info.scflag THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.scflag,/VALID_ID)

  IF output_info.hkflag THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.hkflag,/VALID_ID)

  FOR k = 0, output_info.i3dd-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.i3dds[k],/VALID_ID)

  FOR k = 0, output_info.ipad-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.ipads[k],/VALID_ID)

  IF output_info.hspct THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.hspct,/VALID_ID)

  IF output_info.ispctHe THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.ispctHe,/VALID_ID)

  IF output_info.ispctCNO THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.ispctCNO,/VALID_ID)

  FOR k = 0, output_info.sglbm-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.sglbm[k],/VALID_ID)

  IF output_info.sgl01 THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.sgl01,/VALID_ID)

  IF output_info.sgl1 THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.sgl1,/VALID_ID)

  IF output_info.sgl2 THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.sgl2,/VALID_ID)

  IF output_info.sgl3 THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.sgl3,/VALID_ID)

  IF output_info.sgl01 THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.sgl01,/VALID_ID)

  IF output_info.sta THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.sta,/VALID_ID)

  IF output_info.sto THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.sto,/VALID_ID)

  IF output_info.stabm THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.stabm,/VALID_ID)

  IF output_info.stobm THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.stobm,/VALID_ID)

  IF output_info.hksun THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.hksun,/VALID_ID)

  IF output_info.hkrat THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.hkrat,/VALID_ID)

  IF output_info.hv THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.hv,/VALID_ID)

  IF output_info.subc THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.subc,/VALID_ID)

  IF output_info.hkfcr THEN invalid = invalid + 1 - WIDGET_INFO(panel_ids.hkfcr,/VALID_ID)

  FOR k = 0, output_info.m-1 DO invalid = invalid + 1 - WIDGET_INFO(panel_ids.m[k],/VALID_ID)

  IF invalid NE 0 THEN BEGIN

    rcs_message, 'WARNING, DISPLAY PANEL NOT COMPLETED', /INFORMATIONAL

  ENDIF ELSE BEGIN

    ; set base uvalue to widget IDs

    WIDGET_CONTROL, base, SET_UVALUE=panel_ids

    ; start processing events

    XMANAGER, 'rcs_panel', base, /NO_BLOCK

    ; send event to event manager

    WIDGET_CONTROL, panel_ids.positions, TIMER=output_info.timer

  ENDELSE

  RETURN, panel_ids

END
