;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_PANEL_DRAW_LPANEL
;
; Purpose     :	Does coordinates for lineplot panel.
;
; Explanation :	Does coordinates for lineplot panel.
;
; Use         : < rcs_panel_draw_lpanel, widget_id, output_info, xmargin, ymargin, $
;                 LOG=log, MINIMUM=minimum, MAXIMUM=maximum, STITLE=stitle, SUBTITLES=subtitles, YTITLE=ytitle, $
;                 YTICKV=ytickv, ytickname=ytickname >
;
; Inputs      : widget_id    : LONG id of draw window
;               output_info  : STRUCTURE containing display info
;               xmargin      : INTARR(2) character size of left and right margins.
;               ymargin      : INTARR(2) character size of top and bottom margins.
;
; Opt. Inputs : None.
;
; Outputs     : Draws plot on current graphics device.
;
; Opt. Outputs:	None.
;
; Keywords    : LOG         : INT flag indicating logarithmic display required.
;               MINIMUM     : FLOAT y axis minimum
;               MAXIMUM     : FLOAT y axis maximum
;               STITLE      : STRING side title of plot.
;               SUBTITLES   : STRARR labels
;               YTITLE      : STRING energy axis title.
;               YTICKV      : FLTARR(yticks) ytick values
;               YTICKNAME   : STRARR(yticks) ytick names
;               YSIZ        : FLOAT size of panel in plot window. If set indicates non-widget output.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    : Version 0.1, 30/05/01
;                 Added COMMON block for non-widget plots.
;
; Version     :	Version 0.1, 30/05/01
;-
;**********************************************************

PRO rcs_panel_draw_lpanel, widget_id, output_info, xmargin, ymargin, $
  LOG=log, MINIMUM=minimum, MAXIMUM=maximum, STITLE=stitle, SUBTITLES=subtitles, YTITLE=ytitle, $
  YTICKV=ytickv, ytickname=ytickname, YSIZ=ysiz

  IF NOT KEYWORD_SET(ysiz) THEN BEGIN

    WIDGET_CONTROL, widget_id, GET_VALUE=win

    WSET, win

    !P.CHARSIZE = 1.0

    !P.REGION = [ 0.0, 0.0, 1.0, 1.0]

    !P.MULTI = 0

  ENDIF ELSE BEGIN

    !P.CHARSIZE = 1.0

    !P.REGION = !P.REGION - [0.0, ysiz, 0.0, ysiz]

    !P.MULTI = 0

    win = !D.WINDOW

    no_erase = 1

  ENDELSE

  ; adjust charsize for plots

  ies_charsize

  ; set up axes

  IF N_ELEMENTS(log) EQ 0 THEN log = output_info.log

  IF N_ELEMENTS(ytitle) EQ 0 THEN ytitle = output_info.ztitle

  IF N_ELEMENTS(minimum) EQ 0 THEN minimum = output_info.minimum

  IF N_ELEMENTS(maximum) EQ 0 THEN maximum = output_info.maximum

  IF KEYWORD_SET(ytickv) THEN BEGIN

    no_yaxis = 1

    IF NOT KEYWORD_SET(ytickname) THEN ytickname = rcs_strtrim(ytickv)

  ENDIF

  ies_do_axes, output_info.tstart, output_info.tstop, minimum, maximum, xmargin, ymargin, $
                 XTITLE=output_info.xtitle, YTITLE=ytitle, LOG=log, STITLE=stitle, NO_YAXIS=no_yaxis, $
                 NO_ERASE=no_erase

  ; get character sizes in normal coords

  x_chsize = get_chsize(/X)
  y_chsize = get_chsize(/Y)

  ; plot y axis

  IF KEYWORD_SET(no_yaxis) THEN BEGIN

    AXIS, YAXIS=0, YTICKLEN=-x_chsize, YTICKNAME=ytickname, YTICKS=N_ELEMENTS(ytickv)-1, YTICKV=ytickv, CHARSIZE=!P.CHARSIZE*0.8

  ENDIF

  ; plot sub_titles

  FOR k=0, N_ELEMENTS(subtitles)-1 DO $
    XYOUTS, !P.POSITION(2)+2*x_chsize, !P.POSITION(3)-(1+1.5*k)*y_chsize, subtitles[k],  /NORMAL, CHARSIZE=!P.CHARSIZE, COLOR=rcs_get_color(k)

  ; save coord conversion

  rcs_set_conv, widget_id, {LP_COORD_CONV, win:win, xcoords:!X.S, ycoords:!Y.S, xwindow:!X.WINDOW, ywindow:!Y.WINDOW, clip:!P.CLIP, log:!Y.TYPE}

  ; overplot axes again to neaten up
  ; NB dont use data coords because x axis extended in data coords
  ; NB dont want to use plot again because of multiple plots

  PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
         [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

END
