;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_PANEL_DRAW_WIDGET
;
; Purpose     :	Sets up draw widget panel.
;
; Explanation :	Sets up draw widget panel.
;
; Use         : < rcs_panel_draw_widget, base, pxsize, pysize >
;
; Inputs      :
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : nonwidget : FLAG indicating non-widget output
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 30/05/01
;                 Added COMMON block for storing non-widget coord conversions.
;
; Version     :	Version 0.1, 30/05/01
;-
;**********************************************************

FUNCTION rcs_panel_draw_widget, base, pxsize, pysize, NONWIDGET=nonwidget

  COMMON rcs_coord_conversion_local, n_ids, sp_ids, sp_convs, lp_ids, lp_convs

  IF KEYWORD_SET(nonwidget) THEN BEGIN

    sp_ids = 0

    sp_convs = 0

    lp_ids = 0

    lp_convs = 0

    n_ids = n_ids+1

    ; use -ve values as IDs to distinguish from widget IDs

    RETURN, -n_ids

  ENDIF ELSE BEGIN

    RETURN, WIDGET_DRAW ( base, XSIZE = pxsize, YSIZE = pysize, UVALUE=0, RETAIN=2)

  ENDELSE

END
