;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_PANEL_EVENT
;
; Purpose     :	Manages events from RCS_PANEL.
;
; Explanation : Manages events from RCS_PANEL.
;
; Use         : < rcs_panel_event, event >
;
; Inputs      : event : STRUCTURE containing EVENT info.
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 09/11/00
;                 Changed cal to rcs_cw_tslider to use event.top rather
;                 than event.id. This caused some problems under Unix.
;               Version 0.2, 10/12/00
;                 Added PNG format.
;               Version 0.3, 7/2/01
;                 Added set parameters and redraw commands.
;               Version 0.4, 5/3/01
;                 Changed rcs_cw_tslider parameters.
;               Version 0.5, 30/05/01
;                 Changed mechanism for dealing with nonwidget plots.
;               Version 0.6, 12/07/02
;                 Used ies_tag_exists.
;
; Version     :	Version 0.6, 12/07/02
;-
;**********************************************************

PRO rcs_panel_event, event

   ; get widget IDs

  WIDGET_CONTROL, event.top, GET_UVALUE=panel_ids

  ; get output_info

  WIDGET_CONTROL, panel_ids.info, GET_UVALUE=output_info

  ; get event value
  ; NB CW_PDMENU returns .value tag

  IF ies_tag_exists(event,'VALUE') THEN value = event.value ELSE $
    WIDGET_CONTROL, event.id, GET_VALUE=value

  CASE value OF

    'SET TIME RANGE' : BEGIN

         ; get time limits

         tmin = rcs_get_tmin()

         IF tmin EQ 0 THEN tmin =  output_info.tmax + output_info.pre*60.0 $
         ELSE tmin = tmin < (output_info.tmax + output_info.pre*60.)

         tmax = output_info.tmax + 10*60.0

         times = rcs_cw_tslider(event.top, output_info.tstart, output_info.tstop, tmin, tmax)

         output_info.pre  = (times[0] - output_info.tmax)/60.0

         output_info.post = (times[1] - output_info.tmax)/60.0

         output_info.fulltime = 0

         ; get current positions

         WIDGET_CONTROL, panel_ids.positions, GET_UVALUE=positions, /NO_COPY

         dummy = rcs_panel_update(panel_ids,output_info,positions,/REDRAW)

         ; update positions

         WIDGET_CONTROL, panel_ids.positions, SET_UVALUE=positions, /NO_COPY

         ; set output_info

         WIDGET_CONTROL, panel_ids.info, SET_UVALUE=output_info

      END

    'SET PLOT PARAMETERS' : BEGIN

         ; allow output_info to be updated

         rcs_cw_parameters, event.top, output_info

         ; get current positions

         WIDGET_CONTROL, panel_ids.positions, GET_UVALUE=positions, /NO_COPY

         dummy = rcs_panel_update(panel_ids,output_info,positions,/REDRAW)

         ; update positions

         WIDGET_CONTROL, panel_ids.positions, SET_UVALUE=positions, /NO_COPY

         ; set output_info

         WIDGET_CONTROL, panel_ids.info, SET_UVALUE=output_info

      END

    'REDRAW' : BEGIN

         ; get current positions

         WIDGET_CONTROL, panel_ids.positions, GET_UVALUE=positions, /NO_COPY

         dummy = rcs_panel_update(panel_ids,output_info,positions,/REDRAW)

         ; update positions

         WIDGET_CONTROL, panel_ids.positions, SET_UVALUE=positions, /NO_COPY

         ; set output_info

         WIDGET_CONTROL, panel_ids.info, SET_UVALUE=output_info

      END

    'PAUSE' : BEGIN

         WIDGET_CONTROL, event.id, SET_VALUE='START'

         ; stop widget event calling rcs_panel_timer

         WIDGET_CONTROL, panel_ids.positions, EVENT_PRO=''

         ; get next timer event

         ev = WIDGET_EVENT(panel_ids.positions, BAD_ID=bad_id)

      END

    'START' : BEGIN

         WIDGET_CONTROL, event.id, SET_VALUE='PAUSE'

         ; resume widget event calling rcs_panel_timer

         WIDGET_CONTROL, panel_ids.positions, EVENT_PRO='rcs_panel_timer'

         ; generate next timer event

         WIDGET_CONTROL, panel_ids.positions, TIMER=output_info.timer

      END

    'PRINT.WIN' : BEGIN

         ; create dummy panel widget

         panel_ids = rcs_panel(output_info, /NONWIDGET)

         rcs_get_positions, positions

         dummy = rcs_panel_update(panel_ids,output_info,positions,/WIN)

      END

    'PRINT.PNG' : BEGIN

         ; create dummy panel widget

         panel_ids = rcs_panel(output_info, /NONWIDGET)

         rcs_get_positions, positions

         dummy = rcs_panel_update(panel_ids,output_info,positions,/PNG)

      END

    'PRINT.GIF' : BEGIN

         ; create dummy panel widget

         panel_ids = rcs_panel(output_info, /NONWIDGET)

         rcs_get_positions, positions

         dummy = rcs_panel_update(panel_ids,output_info,positions,/GIF)

      END

    'PRINT.PS' : BEGIN

         ; create dummy panel widget

         panel_ids = rcs_panel(output_info, /NONWIDGET)

         rcs_get_positions, positions

         dummy = rcs_panel_update(panel_ids,output_info,positions,/PS)

      END

    'QUIT' : BEGIN

         ; kill widget hierachy

         WIDGET_CONTROL, event.top, /DESTROY

      END

  ENDCASE

END
