;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_PANEL_PLOT_EPAD
;
; Purpose     :	Plots sector data in spectral plots of counts per channel vs time.
;
; Explanation :	Plots sector data in spectral plots of counts per channel vs time.
;
; Use         : < rcs_panel_plot_epad, widget_ids, header, data, output_info, detector_list, $
;                                    IIMS=iims >
;
; Inputs      : widget_ids   : LONG widget ids of draw window for each detector
;               header       : STRUCTURE IF data set header information
;               data         : STRUCTURE ARRAY IF data set data
;               output_info  : STRUCTURE containing display information
;               detector_list: LONARR list of detectors from IF data for plots
;
; Opt. Inputs : None.
;
; Outputs     : None..
;
; Opt. Outputs:	None.
;
; Keywords    : IIMS : FLAG indicates IIMS rather than IES data
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, MKC, 13/12/00
;                 Corrected bug in processing epad data.
;                 Changed LEAVE to SECTORS in rcs_reform.
;               Version 0.2, 30/05/01
;                 Added common block for non-widget plots.
;               Version 0.3, 09/07/02
;                 Used routine ies_color_scale.
;               Version 0.4, 20/11/03
;                 Renamed routine rcs docal to rcs do cal.
;
; Version     :	Version 0.5, 20/11/03
;-
;**********************************************************

PRO rcs_panel_plot_epad, widget_ids, header, data, output_info, detector_list, IIMS=iims

  ; get data in period of interest

  list = rcs_good_data ( header, data, output_info.tstart, output_info.tstop, NOBAD=output_info.nobad, COUNT=npoints)

  ; return if no data

  IF npoints EQ 0 THEN RETURN

  ; remove offset in internal time

  x = [data[list].time,data[list].endtime]-output_info.tstart

  ; y = [nsectors,ndetectors,nenergies,npoints]

  y = rcs_do_cal ( header, data[list], output_info )

  rcs_reform, x, y, l, header, npoints, RAT=output_info.rat, /SECTORS

  ; plot channels using polyfill

  ; y = [nsectors,ndetectors,nenergies,npoints]

  mvals = data[list].mvals

  ; define dummy positions

  output_chans = rcs_get_sectors(header.nsectors, SHOWCH=output_info.showch)

  ; colour scale

  ies_color_scale, output_info, y

  ; loop over detectors

  FOR d=0, N_ELEMENTS(detector_list)-1 DO BEGIN

    ; retrieve co-ord conversion

    conv = rcs_get_conv(widget_ids[d])

    IF conv.win GE 0 THEN WSET, conv.win

    !X.S = conv.xcoords
    !Y.S = conv.ycoords
    !Y.TYPE = conv.log
    !X.WINDOW = conv.xwindow
    !Y.WINDOW = conv.ywindow
    !P.CLIP = conv.clip

    ; get detector and energy channel

    det = detector_list[d] MOD 3
    eng = detector_list[d] / 3

    ; loop over points

    FOR p = 0, npoints-1 DO BEGIN

      ; get mvals [3,16]

      m = rcs_decode_m(mvals[*,p], IIMS=iims)

      ; select detector [16]

      m = REFORM(m[det,*])

      ; loop over channels
      ; NB default for POLYFILL is no clipping to insist set NOCLIP=0

      FOR c = 0, header.nsectors-1 DO $
        POLYFILL, x[[0,1,1,0,0],p], output_chans[[0,0,1,1,0],c], COLOR=y[c,m[c],eng,p], NOCLIP=0

    ENDFOR

    ; overplot to neaten
    ; NB noclip did not work well enough

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDFOR

END

