;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_PANEL_PLOT_FIT
;
; Purpose     :	Plots results of fits to IES histograms.
;
; Explanation : Plots results of fits to IES histograms.
;
; Use         : < rcs_panel_plot_fit, widget_ids, header, data, output_info, PSYM=psym  >
;
; Inputs      : widget_ids   : LONG widget ids of draw window for each detector
;               header       : STRUCTURE IF data set header information
;               data         L STRUCTURE ARRAY IF data set data
;               output_info  : STRUCTURE containing display information
;
; Opt. Inputs : None.
;
; Outputs     : None..
;
; Opt. Outputs:	None.
;
; Keywords    : PSYM : INT plotting symbol
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 04/04/01
;                 Use start time for plotting.
;               Version 0.2, 30/05/01
;                 Added common block for non-widget plots.
;               Version 0.3, 08/09/01
;                 Added SYMSIZE keyword.
;
; Version     :	Version 0.3, 08/09/01
;-
;**********************************************************

PRO rcs_panel_plot_fit, widget_ids, header, data, output_info, PSYM=psym, SYMSIZE=symsize

  ; get data in period of interest

  list = rcs_good_data ( header, data, output_info.tstart, output_info.tstop, NOBAD=output_info.nobad, COUNT=npoints)

  ; return if no data

  IF npoints EQ 0 THEN RETURN

  IF NOT KEYWORD_SET(psym) THEN psym = 3

  ; remove offset in internal time

  x = data[list].time-output_info.tstart

  ; get histogram data [1,1,256,npoints] --> [256,npoints]

  y = REFORM(data[list].data,256,npoints)

  ; get LUT for each sample

  l = data[list].lut

  ; fit data [256,npoints]

  w = rcs_fit(y, XMAX=100, /QUIET)

  ; get cal data for each sample

  w_cal = rcs_get_cal(l)

  ;test_cal = rcs_get_cal(REFORM(TRANSPOSE(INDGEN(4,9)),36))

  ;for k = 0, npoints-1 do print,w[0,k],w_cal[0,k],w[1,k],w_cal[1,k],w[0,k]-w_cal[0,k],w[1,k]/w_cal[1,k]

  npanels = 3

  FOR d = 0, npanels-1 DO BEGIN

    ; retrieve co-ord conversion

    conv = rcs_get_conv(widget_ids[d])

    IF conv.win GE 0 THEN WSET, conv.win

    !X.S = conv.xcoords
    !Y.S = conv.ycoords
    !Y.TYPE = conv.log
    !X.WINDOW = conv.xwindow
    !Y.WINDOW = conv.ywindow
    !P.CLIP = conv.clip

    CASE d OF

      0 : BEGIN

            ; plot w

            OPLOT, [x], [w[1,*]], PSYM=psym, SYMSIZE=symsize, COLOR=rcs_get_color(0)

            OPLOT, [x], [w[0,*]/10], PSYM=psym, SYMSIZE=symsize, COLOR=rcs_get_color(1)

          END

      1 : BEGIN

            ; plot w.0 - w_cal.0

            OPLOT, [x], [w[0,*]-w_cal[0,*]], PSYM=psym, SYMSIZE=symsize, COLOR=rcs_get_color(0)

          END

      2 : BEGIN

            ; plot w.1/w_cal.1

            OPLOT, [x], [w[1,*]/w_cal[1,*]], PSYM=psym, SYMSIZE=symsize, COLOR=rcs_get_color(0)

          END

    ENDCASE

    ; overplot to neaten
    ; NB noclip did not work well enough

    PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
           [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ENDFOR

END
