;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_PANEL_PLOT_FLAGS
;
; Purpose     :	Plots error flags.
;
; Explanation :	Plots error flags.
;
; Use         : < rcs_panel_plot_flags, widget_ids, header, data, output_info, BITS=bits, OFFSET=offset >
;
; Inputs      : widget_ids   : LONG widget ids of draw window for each detector
;               header       : STRUCTURE IF data set header information
;               data         : STRUCTURE ARRAY IF data set data
;               output_info  : STRUCTURE containing display information
;
; Opt. Inputs : None.
;
; Outputs     : None..
;
; Opt. Outputs:	None.
;
; Keywords    : BITS   : INTARR indices of required flag bits
;               OFFSET : INT specifying plotting offset for flags
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 04/04/01
;                 Changed so that consistent with rcs_panel_plot_lp.
;                 Plot spoint at start time.
;               Version 0.2, 30/05/01
;                 Added common block for non-widget plots.
;
; Version     :	Version 0.2, 30/05/01
;-
;**********************************************************

PRO rcs_panel_plot_flags, widget_id, header, data, output_info, BITS=bits, OFFSET=offset

  ; get data in period of interest
  ; NB dont reject bad data -- this is what is being plotted

  list = rcs_good_data ( header, data, output_info.tstart, output_info.tstop, COUNT=npoints)

  ; return if no data

  IF npoints EQ 0 THEN RETURN

  ; remove offset in internal time

  x = data[list].time-output_info.tstart

  ; retrieve co-ord conversion

  conv = rcs_get_conv(widget_id)

  IF conv.win GE 0 THEN WSET, conv.win

  !X.S = conv.xcoords
  !Y.S = conv.ycoords
  !Y.TYPE = conv.log
  !X.WINDOW = conv.xwindow
  !Y.WINDOW = conv.ywindow
  !P.CLIP = conv.clip

  ; decode  flag bits

  ; get flags

  f = data[list].flag

  ; get flag bits for plotting

  IF NOT KEYWORD_SET(bits) THEN bits = INTARR(8)

  ; get offset

  IF NOT KEYWORD_SET(offset) THEN offset = 0

  ; generate y

  y = REPLICATE(offset,npoints)

  ; plot flag bits

  FOR k = 0, N_ELEMENTS(bits)-1 DO BEGIN

    ; plot unset bit

    OPLOT, [x], [y+k], PSYM=3, COLOR=rcs_get_color(0)

    ; find where bit set

    setlist = WHERE((f AND ISHFT(1,bits[k])) NE 0, count)

    IF count GT 0 THEN OPLOT, [x[setlist]], [y[setlist]+k], PSYM=3, COLOR=rcs_get_color(1)

  ENDFOR

END

