;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_PANEL_PLOT_LUTS
;
; Purpose     :	Plots LUT data in lineplot format in panel.
;
; Explanation :	Plots LUT data in lineplot format in panel.
;
; Use         : < rcs_panel_plot_luts, widget_ids, header, data, output_info, , HIST=hist, HK=hk >
;
; Inputs      : widget_ids   : LONG widget ids of draw window for each detector
;               header       : STRUCTURE IF data set header information
;               data         : STRUCTURE ARRAY IF data set data
;               output_info  : STRUCTURE containing display information
;
; Opt. Inputs : None.
;
; Outputs     : None..
;
; Opt. Outputs:	None.
;
; Keywords    : HIST : FLAG indicates histogram data
;               HK   : FLAG indicates HK data
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 04/04/01
;                 Use start time for plotting.
;               Version 0.2, 30/05/01
;                 Added common block for non-widget plots.
;
; Version     :	Version 0.2, 30/05/01
;-
;**********************************************************

PRO rcs_panel_plot_luts, widget_id, header, data, output_info, HIST=hist, HK=hk

  ; get data in period of interest

  list = rcs_good_data ( header, data, output_info.tstart, output_info.tstop, NOBAD=output_info.nobad, COUNT=npoints)

  ; return if no data

  IF npoints EQ 0 THEN RETURN

  ; remove offset in internal time

  x = data[list].time-output_info.tstart

  l = data[list].lut

  f = data[list].flag

  ; retrieve co-ord conversion

  conv = rcs_get_conv(widget_id)

  IF conv.win GE 0 THEN WSET, conv.win

  !X.S = conv.xcoords
  !Y.S = conv.ycoords
  !Y.TYPE = conv.log
  !X.WINDOW = conv.xwindow
  !Y.WINDOW = conv.ywindow
  !P.CLIP = conv.clip

  ; plot LUT with color coded source
  ; NB remove lut changes or histogram strip no
  ; plot strip no for hist (NB lut invalid)

  IF KEYWORD_SET(hist) THEN BEGIN

    OPLOT, [x], ([l]/4)/2.0-1.0, PSYM=1, COLOR=rcs_get_color(4)

  ENDIF ELSE IF KEYWORD_SET(hk) THEN BEGIN

    OPLOT, [x], [(l MOD 4)+0.1], PSYM=3, COLOR=rcs_get_color(5)

  ENDIF ELSE BEGIN

    FOR k = 0, 3 DO BEGIN

      list = WHERE((ISHFT(f,-1) AND 3) EQ k, count)

      IF count GT 0 THEN OPLOT, [x[list]], ([l[list]] MOD 4), PSYM=3, COLOR=rcs_get_color(k)

    ENDFOR

  ENDELSE

END
