;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_PANEL_TIMER
;
; Purpose     :	Manages TIMER events from RCS_PANEL.
;
; Explanation : Manages TIMER events from RCS_PANEL.
;
; Use         : < rcs_panel_timer, event >
;
; Inputs      : event : STRUCTURE containing EVENT info.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 30/05/01
;                 Moved handling of output_info and positions into this routine.
;
; Version     :	Version 0.1, 30/05/01
;-
;**********************************************************

PRO rcs_panel_timer, event

  ; get widget IDs

  WIDGET_CONTROL, event.top, GET_UVALUE=panel_ids

  ; get output_info

  WIDGET_CONTROL, panel_ids.info, GET_UVALUE=output_info, /NO_COPY

  ; get current positions

  WIDGET_CONTROL, panel_ids.positions, GET_UVALUE=positions, /NO_COPY

  ; keep going

  WIDGET_CONTROL, event.id, TIMER=rcs_panel_update( panel_ids, output_info, positions )

  ; update positions

  WIDGET_CONTROL, panel_ids.positions, SET_UVALUE=positions, /NO_COPY

  ; update output_info

  WIDGET_CONTROL, panel_ids.info, SET_UVALUE=output_info, /NO_COPY

END
