;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_PANEL_UPDATE_PLOT
;
; Purpose     :	Updates plot panel.
;
; Explanation : Updates plot panel.
;
; Use         : < rcs_panel_update_plot, output_info, positions, panel_ids >
;
; Inputs      : output_info : STRUCTURE containing display description
;               positions   : STRUCTURE giving last displayed samples in each panel
;               panel_ids   : STRUCTURE giving widget IDs of panels
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : UPDATED     : FLAG indicating whether plots updated or not.
;
; Written     :	Version 0.0, 22/07/01
;
; Modified    :	Version 0.1, 08/09/01
;                 Added SYMSIZE keyword.
;
; Version     :	Version 0.1, 08/09/01
;-
;**********************************************************

FUNCTION rcs_panel_update_plot, use, header, data, position, panel_id, output_info, detector_list, $
  SPECTRAL=spectral, LINEPLOTP=lineplot, FIT=fit, EPAD=epad, LUTS=luts, CENTROID=centroid, HK1=hk1, HK32=hk32, FLAGS=flags, UPDATED=updated, VERSION=version, $
  SPIN_AVERAGE=spin_average, SHOW_SECTORS=show_sectors, NOCAL=nocal, $
  SECTORS=sectors, ENERGY_RANGE=energy_range, $
  AVERAGE=average, ENERGY_LIST=energy_list, SELECT=select, PSYM=psym, SYMSIZE=symsize, $
  BM=bm, BITS=bits, OFFSET=offset, LUT_HIST=lut_hist, LUT_HK=lut_hk, IIMS=iims

  ; update plots

  IF use NE 0 THEN BEGIN

    list = rcs_get_list( header, data, position, new_position, count)

    IF count GT 0 THEN BEGIN

      IF KEYWORD_SET(spectral) THEN BEGIN

        rcs_panel_plot_sp, panel_id, header, data[list], output_info, detector_list, $
            SPIN_AVERAGE=spin_average, SHOW_SECTORS=show_sectors, NOCAL=nocal, $
            SECTORS=sectors, ENERGY_RANGE=energy_range

      ENDIF ELSE IF KEYWORD_SET(lineplot) THEN BEGIN

        rcs_panel_plot_lp, panel_id, header, data[list], output_info, detector_list, $
            SPIN_AVERAGE=spin_average, SHOW_SECTORS=show_sectors, NOCAL=nocal, $
            AVERAGE=average, ENERGY_LIST=energy_list, SELECT=select, PSYM=psym, SYMSIZE=symsize

      ENDIF ELSE IF KEYWORD_SET(fit) THEN BEGIN

        rcs_panel_plot_fit, panel_id, header, data[list], output_info, PSYM=psym, SYMSIZE=symsize

      ENDIF ELSE IF KEYWORD_SET(epad) THEN BEGIN

        rcs_panel_plot_epad, panel_id, header, data[list], output_info, detector_list, IIMS=iims

      ENDIF ELSE IF KEYWORD_SET(luts) THEN BEGIN

        rcs_panel_plot_luts, panel_id, header, data[list], output_info, HIST=lut_hist, HK=lut_hk

      ENDIF ELSE IF KEYWORD_SET(centroid) THEN BEGIN

        rcs_panel_plot_centroid, panel_id, header, data[list], output_info, detector_list, PSYM=psym, SYMSIZE=symsize, BM=bm

      ENDIF ELSE IF KEYWORD_SET(hk1) THEN BEGIN

        rcs_panel_plot_hk, panel_id, header, data[list], output_info, /HK1

      ENDIF ELSE IF KEYWORD_SET(hk32) THEN BEGIN

        rcs_panel_plot_hk, panel_id, header, data[list], output_info, /HK32

      ENDIF ELSE IF KEYWORD_SET(flags) THEN BEGIN

        rcs_panel_plot_flags, panel_id, header, data[list], output_info, BITS=bits, OFFSET=offset

      ENDIF

      updated = 1

      IF KEYWORD_SET(version) THEN BEGIN

        IF version GT header.version THEN version = header.version

      ENDIF ELSE version = header.version

      RETURN, new_position

    ENDIF

  ENDIF

  RETURN, position

END


