;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_PANEL_UPDATE_PLOTS
;
; Purpose     :	Updates plot panels.
;
; Explanation : Updates plot panels.
;
; Use         : < rcs_panel_update_plots, output_info, positions, panel_ids >
;
; Inputs      : output_info : STRUCTURE containing display description
;               positions   : STRUCTURE giving last displayed samples in each panel
;               panel_ids   : STRUCTURE giving widget IDs of panels
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : UPDATED     : FLAG indicating whether plots updated or not.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, 13/12/00
;                 Fixed bug in use of NOCAL with fit.
;               Version 0.2, 6/2/01
;                 Added pedestals and espct IF data set.
;               Version 0.3, 15/05/01
;                 Added CLEANBM2.
;               Version 0.4, 25/05/01
;                 Added HKSUN and HKRAT.
;                 Removed STA and STO from SGL0/1 plot.
;               Version 0.5, 31/05/01
;                 Added STABM and STOBM.
;               Version 0.6, 12/07/01
;                 Added keyword UPDATED.
;               Version 0.7, 20/07/01
;                 Added keyword VERSION.
;                 Used rcs_panel_update_plot
;               Version 0.8, 08/09/01
;                 Added SYMSIZE keyword.
;               Version 0.9, 09/09/01
;                 Modified PEDESTAL plot.
;               Version 1.0, 08/02/02
;                 Added EPAD2.
;               Version 1.1, 15/05/02
;                 Modified PEDESTAL plot.
;               Version 1.2, 15/12/03
;                 Modified CLEANBM and CLEANBM2 plots so that spin averaged as for E3DDBM.
;
; Version     :	Version 1.2, 15/12/03
;-
;**********************************************************

PRO rcs_panel_update_plots, output_info, positions, panel_ids, UPDATED=updated, VERSION=version

  ; global common blocks

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  ; set up to catch errors

  CATCH, error_status

  IF error_status NE 0 THEN BEGIN

    rcs_message, 'Error message : '+!ERR_STRING,/INFORMATIONAL
    rcs_message, 'Data not plotted',/INFORMATIONAL

    RETURN

  ENDIF

  ; set updated flag

  updated = 0

  ; update plots

  positions.e3dd     = rcs_panel_update_plot( output_info.e3dd, e3ddnm_header, e3ddnm_data, positions.e3dd, panel_ids.e3dds, output_info, $
    WHERE(output_info.use_dets), /SPECTRAL, UPDATED=updated, VERSION=version )

  positions.e3ddbm    = rcs_panel_update_plot( output_info.e3ddbm, e3ddbm_header, e3ddbm_data, positions.e3ddbm, panel_ids.e3ddbms, output_info, $
    WHERE(output_info.use_bmdets), /SPECTRAL, UPDATED=updated, VERSION=version, /SPIN_AVERAGE, SECTORS=output_info.sectors, ENERGY_RANGE=[4,11] )

  positions.clean     = rcs_panel_update_plot( output_info.clean, clean_header, clean_data, positions.clean, panel_ids.cleans, output_info, $
    WHERE(output_info.use_cleans), /SPECTRAL, UPDATED=updated, VERSION=version )

  positions.cleanbm   = rcs_panel_update_plot( output_info.cleanbm, cleanbm_header, cleanbm_data, positions.cleanbm, panel_ids.cleanbms, output_info, $
    WHERE(output_info.use_bmcleans), /SPECTRAL, UPDATED=updated, VERSION=version, /SPIN_AVERAGE, SECTORS=output_info.sectors )

  positions.cleanbm2  = rcs_panel_update_plot( output_info.cleanbm2, cleanbm2_header, cleanbm2_data, positions.cleanbm2, panel_ids.cleanbm2s, output_info, $
    WHERE(output_info.use_bm2cleans), /SPECTRAL, UPDATED=updated, VERSION=version, /SPIN_AVERAGE, SECTORS=output_info.sectors )

;  positions.pedestal  = rcs_panel_update_plot( output_info.pedestal, e3ddnm_header, e3ddnm_data, positions.pedestal, panel_ids.pedestals, output_info, $
;    WHERE(output_info.use_pedestals), /CENTROID, UPDATED=updated, VERSION=version, PSYM=3 )

  IF output_info.pedestal NE 0 THEN BEGIN

    list = rcs_get_list( pedestal_header, pedestal_data, positions.pedestal, new_position, count)

    IF count GT 0 THEN BEGIN

      temp = pedestal_data[list]

      ; calculate 100*tot_2_7/exp_tot

      temp.data[0,*,3] = temp.data[0,*,3]*(1-temp.data[0,*,4]/100.)

      temp.data[0,*,3] = -temp.data[0,*,3] ; invert

      temp.data[0,*,4] = -temp.data[0,*,4]/10. ; invert, reduce range

      positions.pedestal  = rcs_panel_update_plot( output_info.pedestal, pedestal_header, temp, positions.pedestal, panel_ids.pedestals, output_info, $
        WHERE(output_info.use_pedestals), /LINEPLOT, UPDATED=updated, VERSION=version, PSYM=3, /NOCAL, ENERGY_LIST=[1,2,3,4] )

    ENDIF

  ENDIF

  positions.espct     = rcs_panel_update_plot( output_info.espct, espct_header, espct_data, positions.espct, panel_ids.espct, output_info, $
    [0], /SPECTRAL, UPDATED=updated, VERSION=version )

  positions.ehist     = rcs_panel_update_plot( output_info.ehist, ehist_header, ehist_data, positions.ehist, panel_ids.ehist, output_info, $
    [0], /SPECTRAL, UPDATED=updated, VERSION=version, /NOCAL )

  positions.ehist_fit = rcs_panel_update_plot( output_info.fit, ehist_header, ehist_data, positions.ehist_fit, panel_ids.fit, output_info, $
    0, /FIT, UPDATED=updated, VERSION=version, PSYM=4, SYMSIZE=1 )

  positions.ehk       = rcs_panel_update_plot( output_info.ehk, ehk_header, ehk_data, positions.ehk, panel_ids.ehks, output_info, $
    WHERE(output_info.use_ehk), /LINEPLOT, UPDATED=updated, VERSION=version, /NOCAL )

  positions.epad      = rcs_panel_update_plot( output_info.epad, epad_header, epad_data, positions.epad, panel_ids.epads, output_info, $
    WHERE(output_info.use_epad), /EPAD, UPDATED=updated, VERSION=version )

  positions.epad2     = rcs_panel_update_plot( output_info.epad2, epad2_header, epad2_data, positions.epad2, panel_ids.epad2s, output_info, $
    WHERE(output_info.use_epad2), UPDATED=updated, VERSION=version )

  positions.e3dd_luts = rcs_panel_update_plot( output_info.luts, e3ddnm_header, e3ddnm_data, positions.e3dd_luts, panel_ids.lut, output_info, $
    0, /LUTS, UPDATED=updated, VERSION=version )

  positions.ehist_luts = rcs_panel_update_plot( output_info.luts, ehist_header, ehist_data, positions.ehist_luts, panel_ids.lut, output_info, $
    0, /LUTS, UPDATED=updated, VERSION=version, /LUT_HIST )

  positions.hk1_luts  = rcs_panel_update_plot( output_info.luts, hk1_header, hk1_data, positions.hk1_luts, panel_ids.lut, output_info, $
    0, /LUTS, UPDATED=updated, VERSION=version, /LUT_HK )

  dummy               = rcs_panel_update_plot( output_info.scflag, scinfo_header, scinfo_data, positions.scflag, panel_ids.scflag, output_info, $
    [0], /LINEPLOT, UPDATED=updated, VERSION=version, PSYM=3, /NOCAL )

  positions.scflag    = rcs_panel_update_plot( output_info.scflag, scinfo_header, scinfo_data, positions.scflag, panel_ids.scflag, output_info, $
    [0], /FLAGS, UPDATED=updated, VERSION=version, OFFSET=7, BITS=[1,2,4,5] )

  positions.subc      = rcs_panel_update_plot( output_info.subc, scinfo_header, scinfo_data, positions.subc, panel_ids.subc, output_info, $
    [1], /LINEPLOT, UPDATED=updated, VERSION=version, PSYM=3, /NOCAL )

  positions.hk1_flag  = rcs_panel_update_plot( output_info.hkflag, hk1_header, hk1_data, positions.hk1_flag, panel_ids.hkflag, output_info, $
    0, /HK1, UPDATED=updated, VERSION=version )

  positions.hk32_flag = rcs_panel_update_plot( output_info.hkflag, hk32_header, hk32_data, positions.hk32_flag, panel_ids.hkflag, output_info, $
    0, /HK32, UPDATED=updated, VERSION=version )

  positions.hkfcr     = rcs_panel_update_plot( output_info.hkfcr, hk1_header, hk1_data, positions.hkfcr, panel_ids.hkfcr, output_info, $
    [7], /LINEPLOT, UPDATED=updated, VERSION=version, PSYM=3, /NOCAL )

  positions.tmp       = rcs_panel_update_plot( output_info.tmp, hk8_header, hk8_data, positions.tmp, panel_ids.tmp, output_info, $
    [6,7], /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL )

  positions.ipad      = rcs_panel_update_plot( output_info.ipad, ipad_header, ipad_data, positions.ipad, panel_ids.ipads, output_info, $
    WHERE(output_info.use_ipad), /EPAD, UPDATED=updated, VERSION=version, /IIMS )

  positions.hspct     = rcs_panel_update_plot( output_info.hspct, hspct_header, hspct_data, positions.hspct, panel_ids.hspct, output_info, $
    [0], /SPECTRAL, UPDATED=updated, VERSION=version )

  positions.hspct     = rcs_panel_update_plot( output_info.hspct, hspct_header, hspct_data, positions.hspct, panel_ids.hspct, output_info, $
    [0], /SPECTRAL, UPDATED=updated, VERSION=version )

  pos = rcs_panel_update_plot( output_info.ispctHe, ispct_header_He, ispct_data_He, positions.ispct, panel_ids.ispctHe, output_info, $
    [0], /SPECTRAL, UPDATED=updated, VERSION=version )

  IF output_info.ispctCNO EQ 0 THEN positions.ispct = pos

  positions.ispct     = rcs_panel_update_plot( output_info.ispctCNO, ispct_header_CNO, ispct_data_CNO, positions.ispct, panel_ids.ispctCNO, output_info, $
    [0], /SPECTRAL, UPDATED=updated, VERSION=version )

  IF output_info.sectors THEN BEGIN

    positions.sglbm   = rcs_panel_update_plot( output_info.sglbm, sglbm_header, sglbm_data, positions.sglbm, panel_ids.sglbm, output_info, $
      INDGEN(3), /SPECTRAL, UPDATED=updated, VERSION=version, /SECTORS )

    positions.stabm   = rcs_panel_update_plot( output_info.stabm, sglbm_header, sglbm_data, positions.stabm, panel_ids.stabm, output_info, $
      [3], /SPECTRAL, UPDATED=updated, VERSION=version, /SECTORS )

    positions.stobm   = rcs_panel_update_plot( output_info.stobm, sglbm_header, sglbm_data, positions.stobm, panel_ids.stobm, output_info, $
      [4], /SPECTRAL, UPDATED=updated, VERSION=version, /SECTORS )


  ENDIF ELSE BEGIN

    positions.sglbm   = rcs_panel_update_plot( output_info.sglbm, sglbm_header, sglbm_data, positions.sglbm, panel_ids.sglbm, output_info, $
      INDGEN(3), /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL, /SHOW_SECTORS )

    positions.stabm   = rcs_panel_update_plot( output_info.stabm, sglbm_header, sglbm_data, positions.stabm, panel_ids.stabm, output_info, $
      [3], /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL, /SHOW_SECTORS )

    positions.stobm   = rcs_panel_update_plot( output_info.stobm, sglbm_header, sglbm_data, positions.stobm, panel_ids.stobm, output_info, $
      [4], /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL, /SHOW_SECTORS )

  ENDELSE


;temp = sglbm_data[list]
;sta = temp.data[*,3]
;sto = temp.data[*,4]
;temp.data[*,2] = sta/(sto>1)
;temp.data[*,1] = sto/(temp.data[*,0]>1)

;eff_l = 0.049
;eff_p = 0.037

;temp.data[*,0] = sta/(sto>1)

;temp.data[*,1] = (sto - sta*eff_l)/(eff_p-eff_l)

;temp.data[*,2] = (sto - sta*eff_p)/(eff_l-eff_p)

;        rcs_panel_plot_sp, panel_ids.sglbm, sglbm_header, temp, output_info, INDGEN(3), SECTORS=output_info.sectors

  positions.sgl01     = rcs_panel_update_plot( output_info.sgl01, sgl01_header, sgl01_data, positions.sgl01, panel_ids.sgl01, output_info, $
    INDGEN(3), /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL )

  positions.sta       = rcs_panel_update_plot( output_info.sta, sgl01_header, sgl01_data, positions.sta, panel_ids.sta, output_info, $
    [3,5], /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL )

  positions.sto       = rcs_panel_update_plot( output_info.sto, sgl01_header, sgl01_data, positions.sto, panel_ids.sto, output_info, $
    [4,6], /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL )

  positions.sgl1      = rcs_panel_update_plot( output_info.sgl1, sgl01_header, sgl01_data, positions.sgl1, panel_ids.sgl1, output_info, $
    INDGEN(3), /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL )

  positions.sgl2      = rcs_panel_update_plot( output_info.sgl2, sgl2_header, sgl2_data, positions.sgl2, panel_ids.sgl2, output_info, $
    INDGEN(6), /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL )

  positions.sgl3      = rcs_panel_update_plot( output_info.sgl3, sgl3_header, sgl3_data, positions.sgl3, panel_ids.sgl3, output_info, $
    INDGEN(10), /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL )

  positions.hv        = rcs_panel_update_plot( output_info.hv, hk1_header, hk1_data, positions.hv, panel_ids.hv, output_info, $
    [0,1,2], /LINEPLOT, UPDATED=updated, VERSION=version, /SELECT, PSYM=3, /NOCAL )

  IF output_info.hksun NE 0 THEN BEGIN

    list = rcs_get_list( hk32_header, hk32_data, positions.hksun, new_position, count)

    IF count GT 0 THEN BEGIN

      ; allow old hk32 IF sets

      IF (SIZE(hk32_data.data))[2] GE 5 THEN BEGIN

      temp = hk32_data[list]

      temp.data[*,3] = temp.data[*,3]/16.0 ; rescale to 0-16

      rcs_panel_plot_lp, panel_ids.hksun, hk32_header, temp, output_info, [3,4], /SELECT, PSYM=2, /NOCAL

      ENDIF

      positions.hksun = new_position

      updated = 1

      IF KEYWORD_SET(version) THEN BEGIN

        IF version GT hk32_header.version THEN version = hk32_header.version

      ENDIF ELSE version = hk32_header.version

    ENDIF

  ENDIF

  IF output_info.hkrat NE 0 THEN BEGIN

    list = rcs_get_list( hk1_header, hk1_data, positions.hkrat, new_position, count)

    IF count GT 0 THEN BEGIN

      ; allow old hk1 IF sets

      IF (SIZE(hk1_data.data))[2] GE 11 THEN BEGIN

      rcs_panel_plot_lp, panel_ids.hkrat, hk1_header, hk1_data[list], output_info, [8,9,10], /SELECT, PSYM=3, /NOCAL

      positions.hkrat = new_position

      updated = 1

      IF KEYWORD_SET(version) THEN BEGIN

        IF version GT hk1_header.version THEN version = hk1_header.version

      ENDIF ELSE version = hk1_header.version

      ENDIF

    ENDIF

  ENDIF

  IF output_info.i3dd NE 0 THEN BEGIN

    list = rcs_get_list( i3dd_header_H, i3dd_data_H, positions.i3dd, new_position, count)

    IF count GT 0 THEN BEGIN

      detector_list = WHERE(output_info.use_i3dd,ndetectors)

      wpos = 0

      IF output_info.use_i3ddm[0] THEN BEGIN

        rcs_panel_plot_sp, panel_ids.i3dds[wpos:wpos+ndetectors-1], i3dd_header_H, i3dd_data_H[list], $
                           output_info, detector_list, /SPIN_AVERAGE, SECTORS=output_info.sectors

        wpos = wpos + ndetectors

      ENDIF

      IF output_info.use_i3ddm[1] THEN  BEGIN

        rcs_panel_plot_sp, panel_ids.i3dds[wpos:wpos+ndetectors-1], i3dd_header_He, i3dd_data_He[list], $
                           output_info, detector_list, /SPIN_AVERAGE, SECTORS=output_info.sectors

        wpos = wpos + ndetectors

      ENDIF


      IF output_info.use_i3ddm[2] THEN  BEGIN

        rcs_panel_plot_sp, panel_ids.i3dds[wpos:wpos+ndetectors-1], i3dd_header_CNO, i3dd_data_CNO[list], $
                           output_info, detector_list, /SPIN_AVERAGE, SECTORS=output_info.sectors

        wpos = wpos + ndetectors

      ENDIF

      positions.i3dd = new_position

      updated = 1

      IF KEYWORD_SET(version) THEN BEGIN

        IF version GT i3dd_header_H.version THEN version = i3dd_header_H.version

      ENDIF ELSE version = i3dd_header_H.version

    ENDIF

  ENDIF

END
