;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESTORE_CFG
;
; Purpose     :	Restore CFG file.
;
; Use         : < output_info = rcs_restore_cfg() >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : output_info : STRUCTURE containing display info.
;
; Opt. Outputs: None.
;
; Keywords    : FILE : STRING file name for restoration.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 14/2/01
;                 Changed so that returns output_info.
;                 Removed ids from argument list.
;               Version 0.2, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.2, 09/10/03
;-
;**********************************************************


FUNCTION rcs_restore_cfg, FILE=file

  IF NOT KEYWORD_SET(file) THEN BEGIN

    file = ies_pickfile(TITLE='RESTORE CONFIGURATION',COUNT=count,FILTER=['*.cfg'],/MUST_EXIST,PATH=ies_get_dir('CFG',/RAPID))

    IF count NE 1 THEN RETURN, 0

  ENDIF

  output_info = 0

  RESTORE, file

  ; get current output_info default

  default_output_info = rcs_output_info()

  ; copy restored tags to default

  copy_struct, output_info, default_output_info

  ; return successful

  RETURN, default_output_info

END