;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SELECT_PLOT
;
; Purpose     :	Select particular histogram plots.
;
; Explanation : Select particular histogram plots.
;
; Use         : < list = rcs_select_plot(widget_ids >
;
; Inputs      : widget_ids : STRUCTURE ids of draw_widgets
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 7/2/01
;
; Modified    :	None
;
; Version     :	Version 0.0, 7/2/01
;-
;**********************************************************

FUNCTION rcs_select_plot, base, header, data, LIST=list, COUNT=count

  IF NOT KEYWORD_SET(list) THEN list = INDGEN(header.npoints)

  sub_list = rcs_list(rcs_strtrim(list), COUNT=count, TITLE='Select plot numbers', GROUP_LEADER=base)

  IF count EQ 0 THEN RETURN,[-1]

  RETURN, list[sub_list]

END
