;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_SET_CONV
;
; Purpose     :	Set coord conversion for panel defined by id.
;
; Explanation :	Set coord conversion for panel defined by id.
;
; Use         : < rcs_set_conv,id,conv >
;
; Inputs      : id : LONG id identifying panel.
;               conv : STRUCTURE defining coord-conversion
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : NO_COPY : FLAG passed to widget control.
;
; Written     :	Version 0.0, 30/05/01
;
; Modified    :
;
; Version     : Version 0.0, 30/05/01
;-
;**********************************************************

PRO rcs_set_conv, id, conv, NO_COPY=no_copy

  COMMON rcs_coord_conversion_local, n_ids, sp_ids, sp_convs, lp_ids, lp_convs

  ; check if widget or non-widget

  IF id GT 0 THEN BEGIN

    ; widget ID with uvalue used to store conversion

    ; save coord conversion

    WIDGET_CONTROL, id, SET_UVALUE=conv, NO_COPY=no_copy

  ENDIF ELSE BEGIN

    ; non widget id, conversion stored in COMMON block

    CASE STRMID(TAG_NAMES(conv,/STRUCTURE_NAME),0,13) OF

      'SP_COORD_CONV' : IF KEYWORD_SET(sp_convs) THEN BEGIN
                          sp_ids   = [sp_ids,id]
                          sp_convs = [sp_convs,conv]
                        ENDIF ELSE BEGIN
                          sp_ids   = id
                          sp_convs = conv
                        ENDELSE

      'LP_COORD_CONV' : IF KEYWORD_SET(lp_convs) THEN BEGIN
                          lp_ids   = [lp_ids,id]
                          lp_convs = [lp_convs,conv]
                        ENDIF ELSE BEGIN
                          lp_ids   = id
                          lp_convs = conv
                        ENDELSE

      ELSE : rcs_message,/IMPLEMENTATION

    ENDCASE

  ENDELSE

END
