;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_START_PLOT
;
; Purpose     :	Sets up display window.
;
; Explanation : Sets up display window.
;
; Use         : < info = rcs_start_plot(WIN=win, PS=ps, PNG=png, GIF=gif, BWPS=bwps, HEADING=heading) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : info : STRUCTURE containing output file info
;                      0 if non-widget output not specified
;
; Opt. Outputs:	None.
;
; Keywords    : WIN     : plots output in window.
;               PS      : plots output as postscript file
;                               if string then assumes filename
;               PNG     : plots output as PNG file
;                               if string then assumes filename
;               GIF     : plots output as GIF file
;                               if string then assumes filename
;               BWPS    : plots output as black and white postscript file
;                               if string then assumes filename
;               HEADING : heading.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, MKC, 10/12/00
;                 Added PNG format.
;               Version 0.4, 20/07/01
;                 Removed part of footnote to end plot.
;               Version 0.5, 09/07/02
;                 Removed ncolors, WYSIWYG.
;               Version 0.6, 28/03/03
;                 Changed definition of logo positions.
;               Version 0.7, 01/10/03
;                 Added RAPID switch to ies set plot.
;
; Version     :	Version 0.7, 01/10/03
;-
;**********************************************************

FUNCTION rcs_start_plot, WIN=win, PS=ps, PNG=png, GIF=gif, BWPS=bwps, HEADING=heading

  ; set up info

  info = {dev:'', unit:0L, file:'', ytop:0.0, ysiz:0.0, win:KEYWORD_SET(win), ps:KEYWORD_SET(ps), png:KEYWORD_SET(png), gif:KEYWORD_SET(gif)}

  info.dev = !D.NAME

  ; set output device

  IF ies_set_plot( 0, !D.NAME, unit, file, /RAPID, $
                     WINDOWS=win, POSTSCRIPT=ps, PNG=png, GIF=gif) THEN RETURN, 0

  ; set up results

  IF N_ELEMENTS(unit) NE 0 THEN info.unit = unit

  IF N_ELEMENTS(file) NE 0 THEN info.file = file

  ; get character sizes in normal coords

  x_chsize = get_chsize(/X)
  y_chsize = get_chsize(/Y)

  ; check if heading specified

  IF NOT KEYWORD_SET(heading) THEN heading = ''

  XYOUTS, 0.5 - STRLEN(heading)*x_chsize*1.5/2.0,  1-2*y_chsize, heading, CHARSIZE=1.5*!P.CHARSIZE, /NORMAL

  info.ytop = 1-2.5*y_chsize

  ; NB these plots differ from ies_window_plot in that each panel has an x-axis

  info.ysiz = info.ytop-y_chsize*0.7

  RETURN, info

END
