;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_TIME_RANGE_UNCHANGED
;
; Purpose     :	Checks if plot time range unchanged.
;
; Explanation :	Returns 0 or 1 depending on whether time range changed or unchanged.
;
; Use         : < res = rcs_time_range_unchanged(overlap, output_info)
;
; Inputs      : overlap      : STRUCTURE containing time limits of previous display
;               output_info  : STRUCTURE containing display information
;
; Opt. Inputs : None.
;
; Outputs     : res : INT 0 time range changed
;                         1 : time range changed
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 10/12/00
;
; Modified    :
;
; Version     :	Version 0.0, 10/12/00
;-
;**********************************************************

FUNCTION rcs_time_range_unchanged, overlap, output_info

  ; check if time 'range' unchanged -- this is not the same as the time period
  ; if time range changed then scaling is different and have to redraw
;print,anytim2cal([output_info.tstart,output_info.tstop],/msec)
;print,'time_range_unchanged=',time_range_unchanged,' time_in_range=',time_in_range

  RETURN, ABS( overlap.tstop - overlap.tstart - output_info.tstop + output_info.tstart) LT 1e-5

END
