;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_WIDGET
;
; Purpose     :	Creates a draw widget for displaying current data sample.
;
; Explanation :	Uses event timer to periodically update display.
;
; Use         : < widget_ids = rcs_widget(output_info) >
;
; Inputs      : output_info : STRUCTURE describing display
;
; Opt. Inputs : None.
;
; Outputs     : widget_ids : STRUCTURE containing widget ids.
;
; Opt. Outputs:	None.
;
; Keywords    : NONWIDGET : FLAG indicating should create dummy widget for non-widget output.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	Version 0.1, MKC, 10/12/00
;                 Added PNG format.
;               Version 0.2, 26/1/01
;                 Added sample and change range options.
;                 Added SELECT PLOT and REDRAW options.
;               Version 0.3, 16/03/01
;                 Changed SET keyword in ies_ncolors to WYSIWYG.
;               Version 0.4, 30/05/01
;                 Changed mechanism for passing output_info and positions for non-widget plots.
;               Version 0.5, 10/07/02
;                 Removed ncolors.
;
; Version     :	Version 0.5, 10/07/02
;-
;**********************************************************

FUNCTION rcs_widget, output_info, NONWIDGET=nonwidget

  ; NB need to reset values specific to previous context

  output_info.tstart = 0.0d0

  output_info.tstop  = 0.0d0

  output_info.tmax   = 0.0d0

  IF NOT output_info.hist THEN RETURN, 0

  ; set up panel ids structure

  widget_ids = {base:0L, info:0L, positions:0L, hist:0L, plotno:0L}

  IF NOT KEYWORD_SET(nonwidget) THEN BEGIN

    ; set up other widgets
    ; use uvalue to store positions

    rcs_get_positions, positions

    widget_ids.base  = WIDGET_BASE ( TITLE=output_info.title, /COL, UVALUE=0L)

    base  = WIDGET_BASE ( TITLE='HIST', /COL, UVALUE=0L)

    widget_ids.info = WIDGET_BASE ( base, UVALUE=output_info, /ROW)

    dummy = WIDGET_BUTTON(widget_ids.info, VALUE='PAUSE')

    items = [  '1\PRINT',      $
               '0\WIN',        $
               '0\PS',         $
               '0\GIF',        $
               '2\PNG']

    dummy = CW_PDMENU ( widget_ids.info, items, /RETURN_FULL_NAME)

    dummy = WIDGET_BUTTON(widget_ids.info, VALUE='SET PLOT PARAMETERS')

    buttons = WIDGET_BASE(widget_ids.info, /ROW, /NONEXCLUSIVE)

    widget_ids.plotno = WIDGET_BUTTON ( buttons, VALUE='SELECT PLOTS', UVALUE=0)

    dummy = WIDGET_BUTTON(widget_ids.info, VALUE='REDRAW')

    dummy = WIDGET_BUTTON(widget_ids.info, VALUE='QUIT')

    widget_ids.positions = WIDGET_BASE ( base, UVALUE=positions, /NO_COPY, EVENT_PRO='rcs_widget_timer')

    ; make row group for HIST

    widget_ids.hist = WIDGET_DRAW ( base, XSIZE = 800, YSIZE = 600, RETAIN=2)

  ENDIF

  ; do this way for consistency with rcs_panel

  IF KEYWORD_SET(nonwidget) THEN RETURN, widget_ids

  ; realize the widget

  WIDGET_CONTROL, base, /REALIZE

  ; set buttons

  WIDGET_CONTROL, widget_ids.plotno , SET_BUTTON=0

  ; set base uvalue to widget IDs

  WIDGET_CONTROL, base, SET_UVALUE=widget_ids

  ; start processing events

  XMANAGER, 'rcs_widget', base, /NO_BLOCK

  ; send event to event manager

  WIDGET_CONTROL, widget_ids.positions, TIMER=output_info.timer

  RETURN, widget_ids

END
