;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_WIDGET_EVENT
;
; Purpose     :	Manages event from RCS_WIDGET.
;
; Explanation : Manages event from RCS_WIDGET.
;
; Use         : < rcs_widget_event, event >
;
; Inputs      : event : STRUCTURE containing EVENT info.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, MKC, 10/12/00
;                 Added PNG format.
;                 Added SET PLOT PARAMETERS and REDRAW commands.
;               Version 0.2, 30/05/01
;                 Changed mechanism for dealing with nonwidget plots.
;               Version 0.3, 07/09/01
;                 Corrected bugs in dealing with non-wdiegt plots..
;               Version 0.4, 12/07/02
;                 Used ies_tag_exists.
;
; Version     :	Version 0.4, 12/07/02
;-
;**********************************************************

PRO rcs_widget_event, event

   ; get widget IDs

  WIDGET_CONTROL, event.top, GET_UVALUE=widget_ids

  ; get output_info

  WIDGET_CONTROL, widget_ids.info, GET_UVALUE=output_info

  ; get event value
  ; NB CW_PDMENU returns .value tag

  IF ies_tag_exists(event,'VALUE') THEN value = event.value ELSE $
    WIDGET_CONTROL, event.id, GET_VALUE=value

  CASE value OF

    'SELECT PLOTS' : BEGIN

        WIDGET_CONTROL, widget_ids.plotno, SET_UVALUE=event.select

        ; get current positions

        WIDGET_CONTROL, widget_ids.positions, GET_UVALUE=positions, /NO_COPY

        dummy = rcs_widget_update(widget_ids,output_info,positions, /REDRAW, PLOTNO=event.select)

        ; update positions

        WIDGET_CONTROL, widget_ids.positions, SET_UVALUE=positions, /NO_COPY

        ; set output_info

        WIDGET_CONTROL, widget_ids.info, SET_UVALUE=output_info

      END

    'SET PLOT PARAMETERS' : BEGIN

        ; allow output_info to be updated

        rcs_cw_parameters, event.top, output_info

        WIDGET_CONTROL, widget_ids.plotno, GET_UVALUE=plotno

        ; get current positions

        WIDGET_CONTROL, widget_ids.positions, GET_UVALUE=positions, /NO_COPY

        dummy = rcs_widget_update(widget_ids,output_info,positions, /REDRAW, PLOTNO=plotno)

        ; update positions

        WIDGET_CONTROL, widget_ids.positions, SET_UVALUE=positions, /NO_COPY

        ; set output_info

        WIDGET_CONTROL, widget_ids.info, SET_UVALUE=output_info

      END

    'REDRAW' : BEGIN

        ; get current positions

        WIDGET_CONTROL, widget_ids.positions, GET_UVALUE=positions, /NO_COPY

        WIDGET_CONTROL, widget_ids.plotno, GET_UVALUE=plotno

        dummy = rcs_widget_update(widget_ids,output_info,positions, /REDRAW, PLOTNO=plotno)

        ; update positions

        WIDGET_CONTROL, widget_ids.positions, SET_UVALUE=positions, /NO_COPY

        ; set output_info

        WIDGET_CONTROL, widget_ids.info, SET_UVALUE=output_info

      END

    'PAUSE' : BEGIN

         WIDGET_CONTROL, event.id, SET_VALUE='START'

         ; stop widget event calling rcs_widget_timer

         WIDGET_CONTROL, widget_ids.positions, EVENT_PRO=''

         ; get next timer event

         ev = WIDGET_EVENT(widget_ids.positions, BAD_ID=bad_id)

      END

    'START' : BEGIN

         WIDGET_CONTROL, event.id, SET_VALUE='PAUSE'

         ; resume widget event calling rcs_widget_timer

         WIDGET_CONTROL, widget_ids.positions, EVENT_PRO='rcs_widget_timer'

         ; generate next timer event

         WIDGET_CONTROL, widget_ids.positions, TIMER=output_info.timer

      END

    'PRINT.WIN' : BEGIN

         WIDGET_CONTROL, widget_ids.plotno, GET_UVALUE=plotno

         ; create dummy widget widget

         widget_ids = rcs_widget(output_info, /NONWIDGET)

         rcs_get_positions, positions

         dummy = rcs_widget_update(widget_ids,output_info,positions,/WIN, PLOTNO=plotno)

      END

    'PRINT.PNG' : BEGIN

         WIDGET_CONTROL, widget_ids.plotno, GET_UVALUE=plotno

         ; create dummy widget widget

         widget_ids = rcs_widget(output_info, /NONWIDGET)

         rcs_get_positions, positions

         dummy = rcs_widget_update(widget_ids,output_info,positions,/PNG, PLOTNO=plotno)

      END

    'PRINT.GIF' : BEGIN

         WIDGET_CONTROL, widget_ids.plotno, GET_UVALUE=plotno

         ; create dummy widget widget

         widget_ids = rcs_widget(output_info, /NONWIDGET)

         rcs_get_positions, positions

         dummy = rcs_widget_update(widget_ids,output_info,positions,/GIF, PLOTNO=plotno)

      END

    'PRINT.PS' : BEGIN

         WIDGET_CONTROL, widget_ids.plotno, GET_UVALUE=plotno

         ; create dummy widget widget

         widget_ids = rcs_widget(output_info, /NONWIDGET)

         rcs_get_positions, positions

         dummy = rcs_widget_update(widget_ids,output_info,positions,/PS, PLOTNO=plotno)

      END

    'QUIT' : BEGIN

         ; kill widget hierachy

         WIDGET_CONTROL, event.top, /DESTROY

      END

  ENDCASE

END
