;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_WIDGET_TIMER
;
; Purpose     :	Manages TIMER events from RCS_WIDGET.
;
; Explanation : Manages TIMER events from RCS_WIDGET.
;
; Use         : < rcs_widget_timer, event >
;
; Inputs      : event : STRUCTURE containing EVENT info.
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 30/05/01
;                 Moved handling of output_info and positions into this routine.
;
; Version     :	Version 0.1, 30/05/01
;-
;**********************************************************

PRO rcs_widget_timer, event

  ; get widget IDs
  ; using widgets to store values rather than COMMON blocks to allow multiple instances

  WIDGET_CONTROL, event.top, GET_UVALUE=widget_ids

  ; get output_info

  WIDGET_CONTROL, widget_ids.info, GET_UVALUE=output_info, /NO_COPY

  ; get current positions

  WIDGET_CONTROL, widget_ids.positions, GET_UVALUE=positions, /NO_COPY

  ; this updates the widget and sets the timer going again to generate another event

  WIDGET_CONTROL, event.id, TIMER=rcs_widget_update( widget_ids, output_info, positions )

  ; update positions

  WIDGET_CONTROL, widget_ids.positions, SET_UVALUE=positions, /NO_COPY

  ; update output_info

  WIDGET_CONTROL, widget_ids.info, SET_UVALUE=output_info, /NO_COPY

END
