;+
; Project     :	CLUSTER - RAPID
;
; Name        :	RCS_X_SECTORS
;
; Purpose     :	Calculates times corresponding to beginning of sectors.
;
; Explanation :	Data sample contains complete spin of data broken into sectors and a start and end
;               time of the spin. This calculates the start times corresponding to each sector.
;
; Use         : < x = rcs_x_sectors ( times, nsectors) >
;
; Inputs      : times   :  DBLARR[npoints,2] start and end times of each sample
;               nsectors : LONG no of sectors
;
; Opt. Inputs : None.
;
; Outputs     : DBLARR[2,nsectors*npoints] start and end times of each sample
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :
;
; Version     :	Version 0.0, 17/9/00
;-
;**********************************************************

FUNCTION rcs_x_sectors, times, nsectors

  npoints = (SIZE(times))[1]

  ; form [2, npoints] array

  times = REFORM( TRANSPOSE(times), 2, npoints)

  ; interpolate

  times = CONGRID(times,2*nsectors,npoints,/INTERP,/MINUS_ONE)

  RETURN, REFORM(times,2,nsectors*npoints)

END
