;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_4sc_iespa
;
; Purpose     :	Produces 4 spacecraft IES pitch angle survey plots.
;
; Explanation : Produces 4 spacecraft IES pitch angle survey plots.
;
; Use         : < res = rcs_4sc_iespa( start_time, end_time, WINDOWS=windows, PS=postscript, PNG=png, $
;                                      GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange) >
;
; Inputs      : start_time : DOUBLE TAI start time of plot
;               end_time   : DOUBLE TAI end time of plot
;
; Opt. Inputs : None.
;
; Outputs     : res : INT flag indicating success of plot.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;               RANGE       = FLTARR[2] giving count range.
;               ERANGE      = FLTARR[2] giving energy range.
;
; Written     :	Version 0.0, 07/02/02
;
; Modified    :	Version 0.1, 07/02/02
;                 Added /NOBAD to rcs_4SC_process
;               Version 0.2, 15/02/02
;                 Removed day.
;                 Added RANGE, ERANGE keywords.
;               Version 0.3, 10/07/02
;                 Removed COLTAB.
;               Version 0.4, 13/08/02
;                 Used rcs_survey_panel.
;               Version 0.5, 25/11/02
;                 Removed some printout.
;               Version 0.6, 25/02/03
;                 Changed comments.
;                 Added AUX keyword to rcs_survey_panel.
;
; Version     :	Version 0.6, 25/02/03
;-
;**********************************************************

FUNCTION rcs_4sc_iespa, start_time, end_time, WINDOWS=windows, PS=postscript, PNG=png, $
   GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange

  rcs_text, 'PROCESSING IES 4SC PITCH ANGLE PLOTS FOR ' $
    +anytim2cal(start_time)+' to '+anytim2cal(end_time)

  ; save current device

  devname = !D.NAME

  setup = 1

  was_data = 0

  ; do IES pitch angle plots

  npanels = 4

  pg_pos = 0

  scs = ['1','2','3','4']

  FOR k = 0, N_ELEMENTS(scs)-1 DO $
    was_data = was_data OR rcs_survey_panel(devname, file, npanels, pg_pos, scs[k], 'IES_EPAD_16', $
                    'RAPID 4 SC IES-EPAD SURVEY PLOT for ', start_time, end_time, REPLICATE(1,9), $
                    SETUP=setup, YTOP=ytop, YSIZ=ysiz, XMARGIN=xmargin, YMARGIN=ymargin, $
                    WINDOWS=windows, PS=postscript, PNG=png, FORMAT='PITCH ANGLE vs ENERGY', $
                    GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange, /AUX, $
                    /CAL, /DIV, /RAT, /BINS, /NOBAD, /NO_XAXIS, /NO_END, CHARSIZE=0.8)

  ; check if any data

  IF NOT was_data THEN RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /NODATA)

  ; if plotted something then finish off

  IF setup NE 1 THEN ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps

  RETURN, 1

END
