;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_4sc_iims
;
; Purpose     :	Produces 4 spacecraft IIMS survey plots.
;
; Explanation : Produces 4 spacecraft IIMS survey plots.
;
; Use         : < rcs_4sc_iims, start_time, end_time, WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, $
;                             TYPE=type >
;
; Inputs      : start_time, end_time
;               start_time : DOUBLE TAI start time of plot
;               end_time   : DOUBLE TAI end time of plot
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;               RANGE       = FLTARR[2] giving count range.
;               ERANGE      = FLTARR[2] giving energy range.
;
; Written     :	Version 0.0, 07/02/02
;
; Modified    :	Version 0.1, 07/02/02
;                 Added /NOBAD to rcs_4SC_process
;               Version 0.2, 15/02/02
;                 Removed day.
;                 Added RANGE, ERANGE keywords.
;               Version 0.3, 20/06/02
;                 Moved ERANGE, RANGE defaults into this routine.
;               Version 0.4, 10/07/02
;                 Removed COLTAB.
;               Version 0.5, 13/08/02
;                 Used rcs_survey_panel.
;               Version 0.6, 25/11/02
;                 Removed some printout.
;               Version 0.7, 27/02/03
;                 Added CAL, DIV and RAT etc ords to rcs_survey_panel.
;               Version 0.8, 19/01/04
;                 Used SHIFT keyword in rcs 4sc plot.
;
; Version     :	Version 0.8, 19/01/04
;-
;**********************************************************

FUNCTION rcs_4sc_iims, start_time, end_time, WINDOWS=windows, PS=postscript, PNG=png, $
   GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange

  rcs_text, 'PROCESSING IIMS  4SC PLOTS FOR '+ $
    anytim2cal(start_time)+' to '+anytim2cal(end_time)

  ; set up defaults

  IF NOT KEYWORD_SET(range) THEN range = [1e-3,1e4]

  IF NOT KEYWORD_SET(erange) THEN erange = [30,4e4]

  ; save current device

  devname = !D.NAME

  setup = 1

  ; do standard IIMS plots

  npanels = 6

  pg_pos = 0

  ;  SC1

  res = rcs_survey_panel(devname, file, npanels, pg_pos, '1', 'IIMS_HSPCT', $
                    'RAPID 4 SC IIMS-HSPCT SURVEY PLOT for ', start_time, end_time, [1], $
                    /ELOG, /CAL, /DIV, /RAT, /BINS, /NOBAD, $
                    SETUP=setup, $
                    WINDOWS=windows, PS=postscript, PNG=png, /NO_XAXIS, /NO_END, $
                    GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange, XHEADER=header1, XDATA=data1 )

  ;  SC2

  res = rcs_survey_panel(devname, file, npanels, pg_pos, '2', 'IIMS_HSPCT', $
                    'RAPID 4 SC IIMS-HSPCT SURVEY PLOT for ', start_time, end_time, [1], $
                    /ELOG, /CAL, /DIV, /RAT, /BINS, /NOBAD, $
                    SETUP=setup, $
                    WINDOWS=windows, PS=postscript, PNG=png, /NO_XAXIS, /NO_END, $
                    GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange, XHEADER=header2, XDATA=data2 )

  ;  SC3

  res = rcs_survey_panel(devname, file, npanels, pg_pos, '3', 'IIMS_HSPCT', $
                    'RAPID 4 SC IIMS-HSPCT SURVEY PLOT for ', start_time, end_time, [1], $
                    /ELOG, /CAL, /DIV, /RAT, /BINS, /NOBAD, $
                    SETUP=setup, $
                    WINDOWS=windows, PS=postscript, PNG=png, /NO_XAXIS, /NO_END, $
                    GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange, XHEADER=header3, XDATA=data3 )

  ;  SC4

  res = rcs_survey_panel(devname, file, npanels, pg_pos, '4', 'IIMS_HSPCT', $
                    'RAPID 4 SC IIMS-HSPCT SURVEY PLOT for ', start_time, end_time, [1], $
                    /ELOG, /CAL, /DIV, /RAT, /BINS, /NOBAD, $
                    SETUP=setup, $
                    WINDOWS=windows, PS=postscript, PNG=png, /NO_XAXIS, /NO_END, $
                    GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange, XHEADER=header4, XDATA=data4 )


  ; check if any data

  IF NOT KEYWORD_SET(header1) AND NOT KEYWORD_SET(header2) AND $
     NOT KEYWORD_SET(header3) AND NOT KEYWORD_SET(header4) THEN $
         RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /NODATA)

  ;  overlay 1

  ; get integral, time averages and convert to cts/cm2/sr/s

  rcs_4sc_process, start_time, end_time, header1, data1, header2, data2, header3, data3, header4, data4, $
                   atime, adata, adata1, adata2, adata3, adata4, PERIOD=180, /NOBAD

  rcs_4sc_plot, devname, file, start_time, end_time, atime, adata, adata1, adata2, adata3, adata4, $
                WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                GIF=gif, BWPS=bwps, PG_POS=pg_pos, /NO_XAXIS, /NO_END, /FIXPANSIZ, $
                NPANELS=npanels, MINIMUM=1e-3, MAXIMUM=1e4, TITLE=['INTEGRAL','[180s av]']


  pg_pos = pg_pos + 1

  ;  overlay 2

  ; get integral, time averages and convert to cts/cm2/sr/s

  rcs_4sc_process, start_time, end_time, header1, data1, header2, data2, header3, data3, header4, data4, $
                   atime, adata, adata1, adata2, adata3, adata4, PERIOD=8, /NOBAD

  rcs_4sc_plot, devname, file, start_time, end_time, atime, adata, adata1, adata2, adata3, adata4, $
                WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, /SHIFT, $
                GIF=gif, BWPS=bwps, PG_POS=pg_pos, /FIXPANSIZ, $
                NPANELS=npanels, MINIMUM=1e-3, MAXIMUM=60, TITLE=['SCx/MEAN','[8s av]'], $
                YTICKV=[0.001,0.01,0.1,1,10],YTICKNAME=[' ','1','1','1','1']

  pg_pos = pg_pos + 1

  RETURN, 1

END
