;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_4sc_ies
;
; Purpose     :	Produces 4 spacecraft IES survey plots.
;
; Explanation : Produces 4 spacecraft IES survey plots.
;
; Use         : < res = rcs_4sc_ies( WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, $
;                             TYPE=type) >
;
; Inputs      : start_time : DOUBLE TAI start time of plot
;               end_time   : DOUBLE TAI end time of plot
;
; Opt. Inputs : None.
;
; Outputs     : res : INT flag indicating success of plot.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;               RANGE       = FLTARR[2] giving count range.
;               ERANGE      = FLTARR[2] giving energy range.
;               DST         = STRUCTURE array giving DST.
;
; Written     :	Version 0.0, 07/02/02
;
; Modified    :	Version 0.1, 07/02/02
;                 Added /NOBAD to rcs_4SC_process
;               Version 0.2, 15/02/02
;                 Removed day.
;                 Added RANGE, ERANGE keywords.
;               Version 0.3, 26/03/02
;                 Added DST keyword.
;               Version 0.4, 25/11/02
;                 Removed some printout.
;               Version 0.5, 03/04/03
;                 Used ies_set_plot rather than lsh_device.
;               Version 0.6, 24/09/03
;                 Changed initialization of draw widget block.
;               Version 0.7, 01/10/03
;                 Added RAPID switch to ies set plot.
;
; Version     :	Version 0.7, 01/10/03
;-
;**********************************************************

FUNCTION rcs_4sc_line, start_time, end_time, WINDOWS=windows, PS=postscript, PNG=png, $
   GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange, DST=dst

  COMMON ies_draw_widget_block, full_header, full_data, header, data, output_info, output_chans, output_array, $
                                ids, dnfull, dnscroll, files, ephem, mf, at

  rcs_text, 'PROCESSING IES   4SC PLOTS FOR ' $
    +anytim2cal(start_time)+' to '+anytim2cal(end_time)

  ; plot data

  detectors = REPLICATE(1,9)

          ;  SC1

          IF rcs_get_ifdata('1', 'IES_CLEAN', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract ( [start_time, end_time], detectors ) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /DIV, /RAT) THEN $
                 RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

      ; save counts for all detectors and energies

      rcs_draw_widget_block, header1, data1, /GET

            ENDIF

          ENDIF

         ;  SC2

          IF rcs_get_ifdata('2', 'IES_CLEAN', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract ( [start_time, end_time], detectors ) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /DIV, /RAT) THEN $
                 RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

      ; save counts for all detectors and energies

      rcs_draw_widget_block, header2, data2, /GET

            ENDIF

          ENDIF

          ;  SC3

          IF rcs_get_ifdata('3', 'IES_CLEAN', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract ( [start_time, end_time], detectors ) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /DIV, /RAT) THEN $
                 RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

       ; save counts for all detectors and energies

      rcs_draw_widget_block, header3, data3, /GET

            ENDIF

          ENDIF

          ;  SC4

          IF rcs_get_ifdata('4', 'IES_CLEAN', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract ( [start_time, end_time], detectors ) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /DIV, /RAT) THEN $
                 RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

      ; save counts for all detectors and energies

      rcs_draw_widget_block, header4, data4, /GET

            ENDIF

          ENDIF

          ; check if any data

          IF NOT KEYWORD_SET(header1) AND NOT KEYWORD_SET(header2) AND $
             NOT KEYWORD_SET(header3) AND NOT KEYWORD_SET(header4) THEN $
             RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /NODATA)

  ; set period

  IF NOT KEYWORD_SET(period) THEN period = 600

  ; get time averages

  res = rcs_sc_average( start_time, end_time, header1, data1, atime, adata1, PERIOD=60, /NOBAD, /INCLUDE, THRESHOLD=1e5)

  res = rcs_sc_average( start_time, end_time, header2, data2, atime, adata2, PERIOD=60, /NOBAD, /INCLUDE, THRESHOLD=1e5)

  res = rcs_sc_average( start_time, end_time, header3, data3, atime, adata3, PERIOD=60, /NOBAD, /INCLUDE, THRESHOLD=1e5)

  res = rcs_sc_average( start_time, end_time, header4, data4, atime, adata4, PERIOD=60, /NOBAD, /INCLUDE, THRESHOLD=1e5)

  ; test output device

  IF KEYWORD_SET(postscript) THEN BEGIN

    IF ies_set_plot( 0, devname, unit, file, /RAPID, NPLOTS=1, POSTSCRIPT=postscript) THEN rcs_message, 'ERROR IN PLOT SET UP'

  ENDIF ELSE BEGIN

    IF ies_set_plot( 0, devname, unit, file, /RAPID, WINDOWS=windows, GIF=gif, PNG=png) THEN rcs_message, 'ERROR IN PLOT SET UP'

  ENDELSE

  IF NOT KEYWORD_SET(range) THEN range = [1,1e6]

  IF NOT KEYWORD_SET(erange) THEN erange = [1,500]

  ; save current device

  devname = !D.NAME

  npanels = 5

  xmargin = [6,2]
  ymargin = [2,2]

    ; get character sizes in normal coords

    x_chsize = get_chsize(/X)
    y_chsize = get_chsize(/Y)

ytop = 1-2.5*y_chsize

ysiz = (ytop-y_chsize*0.7)/npanels

      ; set up pg_pos

  rcs_4sc_line_plot, 0, ysiz, ytop, start_time, end_time, range, xmargin, ymargin, $
    atime, adata1, /NO_XAXIS

  rcs_4sc_line_plot, 1, ysiz, ytop, start_time, end_time, range, xmargin, ymargin, $
    atime, adata2, /NO_XAXIS

  rcs_4sc_line_plot, 2, ysiz, ytop, start_time, end_time, range, xmargin, ymargin, $
    atime, adata3, /NO_XAXIS

  rcs_4sc_line_plot, 3, ysiz, ytop, start_time, end_time, range, xmargin, ymargin, $
    atime, adata4, /NO_XAXIS

  rcs_4sc_line_multi, 4, ysiz, ytop, start_time, end_time, range, xmargin, ymargin, $
    atime, adata1, adata2, adata3, adata4

  ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, BWPS=bwps, GIF=gif, PNG=png

  ; set up processing info

  output_info.minimum = -1
  output_info.maximum = -1

  RETURN, 1

IOERROR:

  rcs_message, !ERR_STRING, /CONT, /TRACEBACK

  SET_PLOT, devname

  RETURN, 0

END

PRO rcs_4sc_line_plot, pg_pos, ysiz, ytop, start_time, end_time, range, xmargin, ymargin, $
    atime, adata, NO_XAXIS=no_xaxis

      !P.REGION = [ 0.0, ytop-ysiz, 1.0, ytop]  - pg_pos*[ 0.0, ysiz, 0.0, ysiz]

  ; set up axes

  ies_do_axes, start_time, end_time, range[0], range[1], xmargin, ymargin, /ylog, $
      XTITLE='UT', YTITLE='Flux [Cts/cm2/sr/s]', /NO_ERASE, $
      TITLE='SC'+rcs_strtrim(pg_pos+1)+' IES Flux>40keV for each detector', $
      /FIXED_CHARSIZE, NO_XAXIS=no_xaxis

  FOR k =0,8 DO OPLOT, atime-start_time, adata[k,0,*], PSYM=-3, COLOR=rcs_get_color(k)


  PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
         [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

END

PRO rcs_4sc_line_multi, pg_pos, ysiz, ytop, start_time, end_time, range, xmargin, ymargin, $
    atime, adata1, adata2, adata3, adata4, NO_XAXIS=no_xaxis

      !P.REGION = [ 0.0, ytop-ysiz, 1.0, ytop]  - pg_pos*[ 0.0, ysiz, 0.0, ysiz]

  ; set up axes

  ies_do_axes, start_time, end_time, range[0], range[1], xmargin, ymargin, /ylog, $
      XTITLE='UT', YTITLE='Flux [Cts/cm2/sr/s]', /NO_ERASE, TITLE='IES Flux>40kev for detector 0', $
      /FIXED_CHARSIZE, NO_XAXIS=no_xaxis

  OPLOT, atime-start_time, adata1[0,0,*], PSYM=-3, COLOR=rcs_get_color(0)

  OPLOT, atime-start_time, adata2[0,0,*], PSYM=-3, COLOR=rcs_get_color(1)

  OPLOT, atime-start_time, adata3[0,0,*], PSYM=-3, COLOR=rcs_get_color(2)

  OPLOT, atime-start_time, adata4[0,0,*], PSYM=-3, COLOR=rcs_get_color(3)

  PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
         [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

END