;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_4sc_occupancy
;
; Purpose     :	Produces 4 spacecraft IES occupancy survey plot.
;
; Explanation : Produces 4 spacecraft IES occupancy survey plot.
;
; Use         : < res = rcs_4sc_occupancy( WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, $
;                             TYPE=type) >
;
; Inputs      : start_time : DOUBLE TAI start time of plot
;               end_time   : DOUBLE TAI end time of plot
;
; Opt. Inputs : None.
;
; Outputs     : res : INT flag indicating success of plot.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;               RANGE       = FLTARR[2] giving count range.
;               ERANGE      = FLTARR[2] giving energy range.
;               DST         = STRUCTURE array giving DST.
;
; Written     :	Version 0.0, 15/05/02
;                 Adapted from rcs_4sc_line.
;
; Modified    :	Version 0.1, 10/07/02
;                 Removed COLTAB.
;               Version 0.2, 25/11/02
;                 Removed some printout.
;               Version 0.3, 27/02/03
;                 Changed to 4 panels.
;                 Used rcs_survey_panel.
;               Version 0.4, 24/09/03
;                 Removed draw widget block,
;
; Version     :	Version 0.4, 24/09/03
;-
;**********************************************************

FUNCTION rcs_4sc_occupancy, start_time, end_time, WINDOWS=windows, PS=postscript, PNG=png, $
   GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange, DST=dst

  rcs_text, 'PROCESSING OCC   4SC PLOTS FOR ' $
    +anytim2cal(start_time)+' to '+anytim2cal(end_time)

  ; save current device

  devname = !D.NAME

  setup = 1

  was_data = 0

  ; do IES occupancy plots

  npanels = 8

  pg_pos = 0

  ; define 3 energy channels to hold the 2 forms of occupancy and missing counts

  lb = [2,0,0]
  ub = [7,1,7]

  IF NOT KEYWORD_SET(range) THEN range = [1e-3, 100]

  scs = ['1','2','3','4']

  FOR k = 0, N_ELEMENTS(scs)-1 DO $
    was_data = was_data OR rcs_survey_panel(devname, file, npanels, pg_pos, scs[k], 'IES_E3DD', $
                    'RAPID 4 SC IES OCCUPANCY PLOT for ', start_time, end_time, REPLICATE(1,9), $
                    SETUP=setup, YTOP=ytop, YSIZ=ysiz, XMARGIN=xmargin, YMARGIN=ymargin, $
                    WINDOWS=windows, PS=postscript, PNG=png, FORMAT='PITCH ANGLE vs ENERGY', $
                    GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange, LB=lb, UB=ub, PROCNAME='LINEPLOT', $
                    /OCCUPANCY, POINTS=3, AXES=2, /ELOG, /NOBAD, /NO_END)

  ; check if any data

  IF NOT was_data THEN RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /NODATA)

  ; if plotted something then finish off

  IF setup NE 1 THEN ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps

  RETURN, 1

END
