;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_4sc_polar
;
; Purpose     :	Produces 4 spacecraft POLAR survey plots.
;
; Explanation : Produces 4 spacecraft POLAR survey plots.
;
; Use         : < rcs_4sc_polar, day, WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, $
;                             TYPE=type >
;
; Inputs      : day        : STRING day in form yymmdd.
;               start_time : DOUBLE TAI start time of plot
;               end_time   : DOUBLE TAI end time of plot
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;               RANGE       = FLTARR[2] giving count range.
;               ERANGE      = FLTARR[2] giving energy range.
;
; Written     :	Version 0.0, 07/02/02
;
; Modified    : Version 0.1, 15/02/02
;                 Removed day.
;                 Added RANGE, ERANGE keywords.
;               Version 0.2, 14/05/02
;                 Changed internal E0 keyword to LB.
;               Version 0.3, 10/07/02
;                 Removed COLTAB.
;               Version 0.4, 25/11/02
;                 Removed some printout.
;               Version 0.5, 28/03/03
;                 Changed definition of logo positions.
;               Version 0.6, 24/09/03
;                 Changed initialization of draw widget block.
;
; Version     :	Version 0.6, 24/09/03
;-
;**********************************************************

FUNCTION rcs_4sc_polar, start_time, end_time, WINDOWS=windows, PS=postscript, PNG=png, $
   GIF=gif, BWPS=bwps, RANGE=range, ERANGE=erange

  COMMON ies_draw_widget_block, full_header, full_data, header, data, output_info, output_chans, output_array, $
                                ids, dnfull, dnscroll, files, ephem, mf, at

  rcs_text, 'PROCESSING POLAR 4SC PLOTS FOR ' $
    +anytim2cal(start_time)+' to '+anytim2cal(end_time)

  ; save current device

  devname = !D.NAME

  setup = 1

          ; do POLAR plot

          npanels = 8

          pg_pos = 7

          ; ******************** IIMS **********************

          range = [1e-1,1e3]

          erange = [0,12]

          started=0

          lb = [0]

          ;  SC4

          IF rcs_get_ifdata('4', 'IIMS_I3DD_H', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract([start_time, end_time], REPLICATE(1,12), FORMAT='DETECTOR vs SECTOR', LB=lb) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='DETECTOR vs SECTOR') THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)


              ; set options

              rcs_survey_set, RANGE=range, AXES=1, ERANGE=erange, PTITLE='I3DD SC4', /NOBAD

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                                  GIF=gif, BWPS=bwps, PG_POS=pg_pos, NO_XAXIS=started, /NO_END, /FIXPANSIZ, NPANELS=npanels, $
                                  HEADING = 'RAPID 4 SC POLAR SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9), $
                                  SETUP=setup) THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /IOERROR)

              started=1

            ENDIF

          ENDIF

          pg_pos = pg_pos-1

          ;  SC3

          IF rcs_get_ifdata('3', 'IIMS_I3DD_H', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract([start_time, end_time], REPLICATE(1,12), FORMAT='DETECTOR vs SECTOR', LB=lb) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='DETECTOR vs SECTOR') THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

              ; set options

              rcs_survey_set, RANGE=range, AXES=1, ERANGE=erange, PTITLE='I3DD SC3', /NOBAD

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                                  GIF=gif, BWPS=bwps, PG_POS=pg_pos, NO_XAXIS=started, /NO_END, /FIXPANSIZ, NPANELS=npanels, $
                                  HEADING = 'RAPID 4 SC POLAR SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9), $
                                  SETUP=setup) THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /IOERROR)

              started=1

            ENDIF

          ENDIF

          pg_pos = pg_pos-1

          ;  SC2

          IF rcs_get_ifdata('2', 'IIMS_I3DD_H', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract([start_time, end_time], REPLICATE(1,12), FORMAT='DETECTOR vs SECTOR', LB=lb) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='DETECTOR vs SECTOR') THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

              ; set options

              rcs_survey_set, RANGE=range, AXES=1, ERANGE=erange, PTITLE='I3DD SC2',  /NOBAD

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                                  GIF=gif, BWPS=bwps, PG_POS=pg_pos, NO_XAXIS=started, /NO_END, /FIXPANSIZ, NPANELS=npanels, $
                                  HEADING = 'RAPID 4 SC POLAR SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9), $
                                  SETUP=setup) THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /IOERROR)

              started=1

            ENDIF

          ENDIF

          pg_pos = pg_pos-1

          ;  SC1

          IF rcs_get_ifdata('1', 'IIMS_I3DD_H', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract([start_time, end_time], REPLICATE(1,12), FORMAT='DETECTOR vs SECTOR', LB=lb) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='DETECTOR vs SECTOR') THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

              ; set options

              rcs_survey_set, RANGE=range, AXES=1, ERANGE=erange, PTITLE='I3DD SC1', /NOBAD

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                                  GIF=gif, BWPS=bwps, PG_POS=pg_pos, NO_XAXIS=started, /NO_END, /FIXPANSIZ, NPANELS=npanels, $
                                  HEADING = 'RAPID 4 SC POLAR SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9), $
                                  SETUP=setup) THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /IOERROR)

              started=1

            ENDIF

          ENDIF

          pg_pos = pg_pos-1

          ; ******************** IES **********************

          range = [1e2,1e7]

          erange = [0,9]

          ;  SC4

          IF rcs_get_ifdata('4', 'IES_CLEAN', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract( [start_time, end_time], REPLICATE(1,9), FORMAT='DETECTOR vs SECTOR', LB=lb) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='DETECTOR vs SECTOR') THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

              ; set options

              rcs_survey_set, RANGE=range, AXES=1, ERANGE=erange, PTITLE='E3DD SC4', /NOBAD

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                                  GIF=gif, BWPS=bwps, PG_POS=pg_pos, NO_XAXIS=started, /NO_END, /FIXPANSIZ, NPANELS=npanels, $
                                  HEADING = 'RAPID 4 SC POLAR SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9), $
                                  SETUP=setup) THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /IOERROR)

              started=1

            ENDIF

          ENDIF

          pg_pos = pg_pos-1

          ;  SC3

          IF rcs_get_ifdata('3', 'IES_CLEAN', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract( [start_time, end_time], REPLICATE(1,9), FORMAT='DETECTOR vs SECTOR', LB=lb) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='DETECTOR vs SECTOR') THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

              ; set options

              rcs_survey_set, RANGE=range, AXES=1, ERANGE=erange, PTITLE='E3DD SC3', /NOBAD

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                                  GIF=gif, BWPS=bwps, PG_POS=pg_pos, NO_XAXIS=started, /NO_END, /FIXPANSIZ, NPANELS=npanels, $
                                  HEADING = 'RAPID 4 SC POLAR SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9), $
                                  SETUP=setup) THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /IOERROR)

              started=1

            ENDIF

          ENDIF

          pg_pos = pg_pos-1

          ;  SC2

          IF rcs_get_ifdata('2', 'IES_CLEAN', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract( [start_time, end_time], REPLICATE(1,9), FORMAT='DETECTOR vs SECTOR', LB=lb) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='DETECTOR vs SECTOR') THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

              ; set options

              rcs_survey_set, RANGE=range, AXES=1, ERANGE=erange, PTITLE='E3DD SC2',  /NOBAD

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                                  GIF=gif, BWPS=bwps, PG_POS=pg_pos, NO_XAXIS=started, /NO_END, /FIXPANSIZ, NPANELS=npanels, $
                                  HEADING = 'RAPID 4 SC POLAR SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9), $
                                  SETUP=setup) THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /IOERROR)

              started=1

            ENDIF

          ENDIF

          pg_pos = pg_pos-1

          ;  SC1

          IF rcs_get_ifdata('1', 'IES_CLEAN', start_time, end_time, restored_header, restored_data, /QUIET) THEN BEGIN

    ; transfer data to draw widget COMMON block

    rcs_draw_widget_block, restored_header, restored_data, /SET

            ; extract data

            IF rcs_survey_extract( [start_time, end_time], REPLICATE(1,9), FORMAT='DETECTOR vs SECTOR', LB=lb) THEN BEGIN

              ; process data

              IF rcs_survey_calibrate(0, /CAL, /RAT, FORMAT='DETECTOR vs SECTOR') THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /UNFINISHED)

              ; set options

              rcs_survey_set, RANGE=range, AXES=1, ERANGE=erange, PTITLE='E3DD SC1', /NOBAD

              ; plot data

              IF ies_window_plot( devname, file, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, $
                                  GIF=gif, BWPS=bwps, PG_POS=pg_pos, NO_XAXIS=started, /NO_END, /FIXPANSIZ, NPANELS=npanels, $
                                  HEADING = 'RAPID 4 SC POLAR SURVEY PLOT for ', $
                                  FOOTNOTE = 'vs '+STRING(full_header.version) +' '+ies_time(FORM=9), $
                                  SETUP=setup) THEN $
                  RETURN, rcs_returns(devname, file, WINDOWS=windows, PS=postscript, PNG=png, $
                                     GIF=gif, BWPS=bwps, /IOERROR)

              started=1

            ENDIF

          ENDIF

          pg_pos = pg_pos-1

          ; finish plot

          IF KEYWORD_SET(started) THEN ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps

  ; set up processing info

  output_info.minimum = -1
  output_info.maximum = -1

  RETURN, 1

END
