;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_4sc_process
;
; Purpose     :	Processes data for 4 spacecraft survey plots.
;
; Explanation : Processes data for 4 spacecraft survey plots.
;
; Use         : < rcs_4sc_process >
;
; Inputs      : day  : STRING day in form yymmdd.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None
;
; Written     :	Version 0.0, Martin Carter, RAL, 23/03/01
;
; Modified    :	Version 0.1, 24/04/01
;                 Added PERIOD keyword.
;             	Version 0.2, 07/02/02
;                 Added /NOBAD to rcs_4SC_process
;
; Version     :	Version 0.2, 07/02/02
;-
;**********************************************************

PRO rcs_4sc_process, start_time, end_time, header1, data1, header2, data2, header3, data3, header4, data4, $
  atime, adata, adata1, adata2, adata3, adata4, PERIOD=period, NOBAD=nobad

  ; set period

  IF NOT KEYWORD_SET(period) THEN period = 600

  ; get time averages

  res = rcs_sc_average( start_time, end_time, header1, data1, atime, adata1, PERIOD=period, NOBAD=nobad)

  res = rcs_sc_average( start_time, end_time, header2, data2, atime, adata2, PERIOD=period, NOBAD=nobad)

  res = rcs_sc_average( start_time, end_time, header3, data3, atime, adata3, PERIOD=period, NOBAD=nobad)

  res = rcs_sc_average( start_time, end_time, header4, data4, atime, adata4, PERIOD=period, NOBAD=nobad)

  ; compare with mean
  ; remember that data for SC may not exist

  freq = INTARR(N_ELEMENTS(atime))

  adata = 0

  IF N_ELEMENTS(adata1) GT 0 THEN BEGIN

    list = WHERE(adata1 NE 0, count)

    IF count NE 0 THEN BEGIN

      freq[list] = freq[list]+1

      adata = adata + adata1

    ENDIF

  ENDIF

  IF N_ELEMENTS(adata2) GT 0 THEN BEGIN

    list = WHERE(adata2 NE 0, count)

    IF count NE 0 THEN BEGIN

      freq[list] = freq[list]+1

      adata = adata + adata2

    ENDIF

  ENDIF

  IF N_ELEMENTS(adata3) GT 0 THEN BEGIN

    list = WHERE(adata3 NE 0, count)

    IF count NE 0 THEN BEGIN

      freq[list] = freq[list]+1

      adata = adata + adata3

    ENDIF

  ENDIF

  IF N_ELEMENTS(adata4) GT 0 THEN BEGIN

    list = WHERE(adata4 NE 0, count)

    IF count NE 0 THEN BEGIN

      freq[list] = freq[list]+1

      adata = adata + adata4

    ENDIF

  ENDIF

  adata = adata/(freq > 1)

END
