;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	RCS_4SC_SURVEY
;
; Purpose     :	Produces 4 spacecraft survey plots.
;
; Explanation : Produces 4 spacecraft survey plots.
;
; Use         : < rcs_4sc_survey, WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, $
;                             TYPE=type >
;
; Inputs      : day    : STRING day in form yymmdd.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;               TYPE        = INT giving type of survey plot required.
;                                0 : IES plot
;                                1 : IIMS plot
;               NPLOT       = INT selecting period of day for plot.
;               DAY         = STRING day in format yymmdd.
;               TIME_RANGE  = [2] any sort of time giving start and stop times of
;                             period of interest
;               RANGE       = FLTARR[2] giving count range.
;               ERANGE      = FLTARR[2] giving energy range.
;               DST         = STRUCTURE array giving DST.
;
; Written     :	Version 0.0, Martin Carter, RAL, 16/2/01
;
; Modified    :	Version 0.1, 13/03/01
;                 Fixed bug if data for a SC did not exist.
;                 Added IIMS survey plot.
;                 Removed ids from rcs_text.
;               Version 0.2, 23/03/01
;                 Fixed bug where no SC have any data.
;                 Added routine rcs_4sc_process
;               Version 0.3, 10/04/01
;                 Removed 'created plot' printout.
;                 Converted other RETURNs to GOTO UNFINISHEDs.
;                 Used rcs_survey_extract with INTEGRAL keyword.
;                 Changed IES count rate range.
;                 Changed HSPCT energy range.
;                 Changed argument list of rcs_restore_ifdata.
;                 Changed difference plot.
;                 Changed energy range of integral plot.
;               Version 0.4, 03/05/01
;                 Added DETECTOR vs SECTOR IES plot.
;               Version 0.5, 16/05/01
;                 Changed setup usage.
;                 Reversed order of TYPE=2 to ensure x-axis drawn and added explicit end plot.
;                 Changed POLAR ranges.
;               Version 0.6, 07/06/01
;                 Ensured did not try to end plot unless plot started for type=2.
;               Version 0.7, 07/07/01
;                 Added keyword NPLOT to select period of plot.
;                 Changed rcs_survey_extract to function.
;               Version 0.8, 18/07/01
;                 Generalized e0 in polar plots.
;                 Added source argument.
;               Version 0.9, 09/09/01
;                 Changed IES range in POLAR plots to 1e2-1e7.
;               Version 1.0, 11/10/01
;                 Corrected bug in ies_4sc plotting.
;                 Used QUIET keyword.
;               Version 1.1, 06/02/02
;                 Changed last IES panel to high time resolution panel.
;                 Added NODATA jump.
;                 Moved plot stuff to other procedures.
;               Version 1.2, 14/02/02
;                 Added START_TIME and END_TIME keywords.
;                 Made day a KEYWORD.
;                 Added RANGE, ERANGE keywords.
;               Version 1.3, 01/03/02
;                 Added PITCH ANGLE survey plot.
;               Version 1.4, 26/03/02
;                 Added DST keyword.
;               Version 1.5, 2/5/02
;                 Added new plot using rcs_4sc_line.
;               Version 1.6, 14/5/02
;                 Added new plot using rcs_4sc_occupancy.
;                 Returned if no time specified.
;
; Version     :	Version 1.6, 14/5/02
;-
;**********************************************************

PRO rcs_4sc_survey, WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps, $
                    TYPE=type, NPLOT=nplot, DAY=day, TIME_RANGE=time_range, RANGE=range, $
                    ERANGE=erange, DST=dst

  ; set up time range

  rcs_set_time_range, start_time, end_time, NPLOT=nplot, DAY=day, TIME_RANGE=time_range

  IF NOT KEYWORD_SET(start_time) THEN RETURN

  ; check type set up

  IF N_ELEMENTS(type) EQ 0 THEN type = 0

  ; avoid passing back arguments which may be set up within this routine
  ; can have unwanted side effects

  IF KEYWORD_SET(postscript) THEN BEGIN
    new_postscript = postscript
  ENDIF ELSE IF KEYWORD_SET(bwps) THEN BEGIN
    new_bwps = bwps
  ENDIF ELSE IF KEYWORD_SET(png) THEN BEGIN
    new_png = png
  ENDIF ELSE IF KEYWORD_SET(gif) THEN BEGIN
    new_gif = gif
  ENDIF

  ; set default plot type

  IF NOT KEYWORD_SET(windows) AND NOT KEYWORD_SET(postscript) AND $
     NOT KEYWORD_SET(png) AND NOT KEYWORD_SET(gif) AND NOT KEYWORD_SET(bwps) THEN windows=1

  CASE type OF

    0 : res = rcs_4sc_ies( start_time, end_time, WINDOWS=windows, PS=new_postscript, PNG=new_png, $
          GIF=new_gif, BWPS=new_bwps, RANGE=range, ERANGE=erange, DST=dst)

    1 : res = rcs_4sc_iims( start_time, end_time, WINDOWS=windows, PS=new_postscript, PNG=new_png, $
          GIF=new_gif, BWPS=new_bwps, RANGE=range, ERANGE=erange)

    2 : res = rcs_4sc_polar( start_time, end_time, WINDOWS=windows, PS=new_postscript, PNG=new_png, $
          GIF=new_gif, BWPS=new_bwps, RANGE=range, ERANGE=erange)

    3 : res = rcs_4sc_iespa( start_time, end_time, WINDOWS=windows, PS=new_postscript, PNG=new_png, $
          GIF=new_gif, BWPS=new_bwps, RANGE=range, ERANGE=erange)

;    4 : res = rcs_4sc_line( start_time, end_time, WINDOWS=windows, PS=new_postscript, PNG=new_png, $
;          GIF=new_gif, BWPS=new_bwps, RANGE=range, ERANGE=erange)

    5 : res = rcs_4sc_occupancy( start_time, end_time, WINDOWS=windows, PS=new_postscript, PNG=new_png, $
          GIF=new_gif, BWPS=new_bwps, RANGE=range, ERANGE=erange)

    ELSE : rcs_message, 'TYPE NOT KNOWN'

  ENDCASE

END
