;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_blank_plot
;
; Purpose     :	Produces blank plot with error message.
;
; Explanation : Produces blank plot with error message.
;
; Use         : < rcs_blank_plot, devname, file, message, WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps >
;
; Inputs      : devname    : STRING standard device name.
;               file       : STRING giving output file name, needed externally for footnote
;               message    : STRING error message
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /PS         = plots output as postscript file
;                                if string then assumes it is a file name
;               /PNG        = plots output as PNG file
;                                if string then assumes it is a file name
;               /GIF        = plots output as GIF file
;                                if string then assumes it is a file name
;               /BWPS       = plots output as black and white postscript file
;                                if string then assumes it is a file name
;
; Written     :	Version 0.0, 13/01/03
;
; Modified    : Version 0.1, 28/03/03
;                 Changed definition of logo positions.
;               Version 0.2, 15/07/03
;                 Used ies_end_plot.
;               Version 0.3, 01/10/03
;                 Added RAPID swicth to ies et plot.
;
; Version     :	Version 0.3, 01/10/03
;-
;**********************************************************

PRO rcs_blank_plot, devname, file, message, WINDOWS=windows, PS=postscript, PNG=png, GIF=gif, BWPS=bwps

  ; set default plot type

  IF NOT KEYWORD_SET(postscript) AND NOT KEYWORD_SET(png) AND NOT KEYWORD_SET(gif) AND NOT KEYWORD_SET(bwps) THEN windows=1

  IF ies_set_plot( 0, devname, unit, file, /RAPID, $
     WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps) THEN RETURN

  ; get character sizes in normal coords

  charsize=2

  x_chsize = charsize*get_chsize(/X)

  XYOUTS, 0.5 - STRLEN(message)*x_chsize/2.0, 0.5, message, CHARSIZE=charsize, /NORMAL

  ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps

END
