;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_calculate_occupancy
;
; Purpose     :	Calculates IES occupancy and missing counts.
;
; Explanation : Calculates IES occupancy and missing counts.
;
; Use         : < >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 15/05/02
;
; Modified    :	Version 0.1, 28/11/02
;                 Added 'spins' to labels.
;               Version 0.2, 24/10/03
;                 Used ies lut list.
;               Version 0.3, 06/11/03
;                 Corrected bug with size.
;
; Version     :	Version 0.3, 06/11/03
;-
;**********************************************************

PRO rcs_calculate_occupancy

  COMMON ies_draw_widget_block, full_header, full_data, header, data, output_info, output_chans, output_array, $
                                ids, dnfull, dnscroll, files, ephem, mf, at

  ; have 2 copies of energy bands

  IF header.tstart LT anytim2tai('25/jan/2002 08:45') THEN BEGIN
    spin_cycles = 32
    detector_list = [3,4,5]
  ENDIF ELSE BEGIN
    spin_cycles = 8
    detector_list = [4,8]
  ENDELSE

  ; do necessary bits and bobs

  output_info.band_labels[0:2] = ['1 spin',rcs_strtrim(spin_cycles)+' spins','MISSING']

  header.ztitle = 'Occ. [%]'

  ; average over detectors in detector list

  temp = REFORM(TOTAL(data.data[0,detector_list,0],2))/N_ELEMENTS(detector_list)

  ; average over all detectors for missing counts

  tot = REFORM(TOTAL(data.data[0,*,2],2))/header.ndetectors

  ; average over spin cycles
  ; ignore data gaps
  ; ignore bad data at start of new lut
  ; ignore subcommutation index

  ; get list of runs of luts

  lut_list = ies_lut_list(data.lut, header.nluts)

  ; loop through runs of each lut

  ttemp = FLTARR(header.npoints)

  tttemp = FLTARR(header.npoints)

  filter = REPLICATE(1, spin_cycles)

  FOR l = 0L, N_ELEMENTS(lut_list)-1 DO BEGIN

    ; get lut and no. of points in run

    lut = lut_list[l].lut

    ; get expected total counts

    totcts = rcs_check_ies(lut)

    ; get average over spin cycles

    IF lut_list[l].size GT spin_cycles THEN BEGIN

      ttemp[lut_list[l].st:lut_list[l].en] = CONVOL(temp[lut_list[l].st:lut_list[l].en], filter, FLOAT(spin_cycles), CENTER=0)

    ENDIF ELSE BEGIN

      ttemp[lut_list[l].st:lut_list[l].en] = 0

    ENDELSE

    ; get occupancy

    temp[lut_list[l].st:lut_list[l].en] = temp[lut_list[l].st:lut_list[l].en]/FLOAT(totcts)*100.

    ttemp[lut_list[l].st:lut_list[l].en] = ttemp[lut_list[l].st:lut_list[l].en]/FLOAT(totcts)*100.

    ; get missing counts

    tttemp[lut_list[l].st:lut_list[l].en] = (1-tot[lut_list[l].st:lut_list[l].en]/FLOAT(totcts))*100.

  ENDFOR

  ; put results for each spin in detector 0, energy 0
  ; put average over spin cycles into detector 0, energy 1

  output_array[0,0,*] = temp
  output_array[0,1,*] = ttemp
  output_array[0,2,*] = tttemp

END