;+
; Project     :	CLUSTER II/RAPID
;
; Name        :	rcs_draw_widget_block
;
; Purpose     :	Initializes the draw_widget COMMON block used to transfer data to the ies_plotting SW
;
; Explanation : Initializes the draw_widget COMMON block used to transfer data to the ies_plotting SW.
;               Needs to explicitly set mf, at and ephem.
;
; Use         : < rcs_initialize_draw_widget_block, new_header, new_data >
;
; Inputs      : new_header : STRUCTURE header
;               new_data   : STRUCTURE ARRAY data
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : SET : FLAG indicating should set full header and data in draw widget block
;               GET : FLAG indicating should get header and data from draw widget block
;
; Written     :	Version 0.0, 24/09/03
;
; Modified    :
;
; Version     :	Version 0.0, 24/09/03
;-
;**********************************************************

PRO rcs_draw_widget_block, new_header, new_data, SET=set, GET=get

  COMMON ies_draw_widget_block, full_header, full_data, header, data, output_info, output_chans, output_array, $
                                ids, dnfull, dnscroll, files, ephem, mf, at

  IF KEYWORD_SET(get) THEN BEGIN

    IF N_ELEMENTS(header) EQ 0 OR N_ELEMENTS(data) EQ 0 THEN rcs_message, /IMPLEMENTATION

    new_header = header

    new_data = data

    RETURN

  ENDIF

  full_header = new_header

  full_data = new_data[0:new_header.npoints-1]

  ; these may already have been set so need initializing

  ephem = 0

  mf = 0

  at = 0

  files = ''

END
